jQuery(document).ready(function($) {
    // Handle element insertion button clicks
    $('.insert-fc-element').on('click', function() {
        const elementType = $(this).data('type');
        
        // Show the appropriate modal based on element type
        $(`#fc-${elementType}-modal`).css('display', 'block');
    });
    
    // Close modals when clicking the × button
    $('.fc-modal-close').on('click', function() {
        $(this).closest('.fc-modal').css('display', 'none');
    });
    
    // Close modals when clicking Cancel
    $('.fc-modal-cancel').on('click', function() {
        $(this).closest('.fc-modal').css('display', 'none');
    });
    
    // Close modals when clicking outside the modal content
    $(window).on('click', function(event) {
        if ($(event.target).hasClass('fc-modal')) {
            $('.fc-modal').css('display', 'none');
        }
    });
    
    // Handle Button insertion
    $('.fc-insert-button').on('click', function() {
        const buttonType = $('#fc-button-type').val();
        const buttonClass = $('#fc-button-type option:selected').data('class');
        const buttonText = $('#fc-button-text').val() || 'Click Here';
        const buttonUrl = $('#fc-button-url').val() || 'https://';
        const openNewTab = $('#fc-button-newtab').is(':checked');
        
        // Generate HTML
        const target = openNewTab ? ' target="_blank" rel="noopener"' : '';
        
        // Generate different HTML based on button type
        let buttonHtml = '';
        if (buttonType === 'link') {
            buttonHtml = '<a href="' + buttonUrl + '" class="' + buttonClass + '"' + target + '>' + buttonText + '</a>';
        } else {
            buttonHtml = '<a href="' + buttonUrl + '" class="' + buttonClass + '"' + target + '><span>' + buttonText + '</span></a>';
        }
        
        // Insert into editor
        insertIntoEditor(buttonHtml);
        
        // Close modal
        $('#fc-button-modal').css('display', 'none');
    });
    
    // Handle Card insertion
    $('.fc-insert-card').on('click', function() {
        const cardTitle = $('#fc-card-title').val() || 'Card Title';
        const cardContent = $('#fc-card-content').val() || '';
        const cardStyle = $('#fc-card-style').val();
        const cardWidth = $('#fc-card-width').val();
        const cardAlign = $('#fc-card-align').val();
        
        // Generate card class based on style
        let cardClass = 'fcom-card';
        if (cardStyle === 'borderless') {
            cardClass = 'fcom-card-borderless';
        }
        
        // Add width class
        if (cardWidth !== 'full') {
            cardClass += ` fcom-card-${cardWidth}`;
        }
        
        // Add alignment class if not full width
        if (cardWidth !== 'full') {
            cardClass += ` fcom-card-align-${cardAlign}`;
        }
        
        // Generate HTML
        const cardHtml = `
            <div class="${cardClass}">
                <div class="fcom-card-header">
                    <h3>${cardTitle}</h3>
                </div>
                <div class="fcom-card-body">
                    ${cardContent}
                </div>
            </div>
        `;
        
        // Insert into editor
        insertIntoEditor(cardHtml);
        
        // Close modal
        $('#fc-card-modal').css('display', 'none');
    });
    
    // Handle Alert insertion
    $('.fc-insert-alert').on('click', function() {
        const alertType = $('#fc-alert-type').val();
        const alertTitle = $('#fc-alert-title').val();
        const alertContent = $('#fc-alert-content').val() || '';
        
        // Generate alert class based on type
        const alertClass = `fcom-alert fcom-alert-${alertType}`;
        
        // Get icon based on alert type
        let iconSvg = '';
        switch(alertType) {
            case 'info':
                iconSvg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1024 1024" style="color: #909399;"><path fill="currentColor" d="M512 64a448 448 0 1 1 0 896 448 448 0 0 1 0-896zm0 832a384 384 0 0 0 0-768 384 384 0 0 0 0 768zm48-176a48 48 0 1 1-96 0 48 48 0 0 1 96 0zm-48-464a32 32 0 0 1 32 32v288a32 32 0 0 1-64 0V288a32 32 0 0 1 32-32z"></path></svg>';
                break;
            case 'success':
                iconSvg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1024 1024" style="color: #67C23A;"><path fill="currentColor" d="M512 64a448 448 0 1 1 0 896 448 448 0 0 1 0-896zm-55.808 536.384-99.52-99.584a38.4 38.4 0 1 0-54.336 54.336l126.72 126.72a38.272 38.272 0 0 0 54.336 0l262.4-262.464a38.4 38.4 0 1 0-54.272-54.336L456.192 600.384z"></path></svg>';
                break;
            case 'warning':
                iconSvg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1024 1024" style="color: #E6A23C;"><path fill="currentColor" d="M512 64a448 448 0 1 1 0 896 448 448 0 0 1 0-896zm0 832a384 384 0 0 0 0-768 384 384 0 0 0 0 768zm48-176a48 48 0 1 1-96 0 48 48 0 0 1 96 0zm-48-464a32 32 0 0 1 32 32v288a32 32 0 0 1-64 0V288a32 32 0 0 1 32-32z"></path></svg>';
                break;
            case 'error':
                iconSvg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1024 1024" style="color: #F56C6C;"><path fill="currentColor" d="M512 64a448 448 0 1 1 0 896 448 448 0 0 1 0-896zm0 832a384 384 0 0 0 0-768 384 384 0 0 0 0 768zm-48-247.616L668.608 444.8a38.4 38.4 0 1 0-54.336-54.336L464 539.808 313.728 390.464a38.4 38.4 0 1 0-54.336 54.336L409.6 594.208 259.264 744.544a38.4 38.4 0 1 0 54.336 54.336L464 648.576l150.272 149.344a38.4 38.4 0 1 0 54.336-54.336L518.4 594.208z"></path></svg>';
                break;
        }
        
        // Generate HTML
        let alertHtml = `
            <div class="${alertClass}">
                <div class="fcom-alert-icon">
                    <i class="el-icon">${iconSvg}</i>
                </div>
                <div class="fcom-alert-content">`;
        
        // Add title if provided
        if (alertTitle) {
            alertHtml += `<span class="fcom-alert-title">${alertTitle}</span>`;
        }
        
        // Add content
        alertHtml += `${alertContent}</div></div>`;
        
        // Insert into editor
        insertIntoEditor(alertHtml);
        
        // Close modal
        $('#fc-alert-modal').css('display', 'none');
    });
    
    // Handle Columns insertion - improved version
    $('.fc-insert-columns').on('click', function() {
        const columnsCount = parseInt($('#fc-columns-count').val()) || 2;
        const columnsGap = $('#fc-columns-gap').val() || 'medium';
        
        // Generate columns class
        const columnsClass = `fcom-columns fcom-columns-gap-${columnsGap}`;
        
        // Generate HTML
        let columnsHtml = `<div class="${columnsClass}">`;
        
        // Add column divs with placeholder content
        for (let i = 0; i < columnsCount; i++) {
            columnsHtml += `
                <div class="fcom-column">
                    <div class="fcom-card">
                        <div class="fcom-card-header">
                            <h3>Column ${i + 1} Title</h3>
                        </div>
                        <div class="fcom-card-body">
                            <p>Replace this with your content for column ${i + 1}.</p>
                        </div>
                    </div>
                </div>
            `;
        }
        
        columnsHtml += `</div>`;
        
        // Insert into editor
        insertIntoEditor(columnsHtml);
        
        // Close modal
        $('#fc-columns-modal').css('display', 'none');
    });
    
    // Helper function to insert content into the editor
    function insertIntoEditor(content) {
        if (typeof wp !== 'undefined' && wp.editor && wp.editor.insert) {
            wp.editor.insert(content);
        } else {
            // Fallback for older WordPress versions
            const editor = tinyMCE.get('content');
            if (editor && !editor.isHidden()) {
                editor.execCommand('mceInsertContent', false, content);
            } else {
                // Text editor mode
                const $textarea = $('#content');
                const currentContent = $textarea.val();
                const caretPos = $textarea[0].selectionStart;
                
                $textarea.val(
                    currentContent.substring(0, caretPos) + 
                    content + 
                    currentContent.substring(caretPos)
                );
            }
        }
    }
}); 