(function(wp) {
const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
    const { InspectorControls, useBlockProps, InnerBlocks, PanelColorSettings } = wp.blockEditor;
    const { PanelBody, RangeControl, __experimentalBoxControl } = wp.components;
    const el = wp.element.createElement;

    function getInlineStyles(attributes) {
        const { backgroundColor, textColor, borderColor, borderWidth, borderRadius, paddingValues, maxWidth } = attributes;
        const styles = {};
        if (backgroundColor) styles.backgroundColor = backgroundColor;
        if (textColor) styles.color = textColor;
        if (borderColor) styles.borderColor = borderColor;
        if (borderWidth !== undefined) styles.borderWidth = `${borderWidth}px`;
        if (borderRadius !== undefined) styles.borderRadius = `${borderRadius}px`;
        if (maxWidth) styles.maxWidth = `${maxWidth}px`;
        if (paddingValues) {
            if (paddingValues.top) styles.paddingTop = paddingValues.top;
            if (paddingValues.right) styles.paddingRight = paddingValues.right;
            if (paddingValues.bottom) styles.paddingBottom = paddingValues.bottom;
            if (paddingValues.left) styles.paddingLeft = paddingValues.left;
        }
        if (styles.borderWidth || styles.borderColor) {
            styles.borderStyle = 'solid'; 
        }

        return styles;
    }

registerBlockType('fca-pages/card', {
        apiVersion: 3,
        title: __('FC Card', 'fca-pages'),
        icon: 'index-card',
        category: 'fca-blocks',
        description: __('A customizable card component.', 'fca-pages'),
        attributes: {
            align: { type: 'string' },
            backgroundColor: { type: 'string' },
            textColor: { type: 'string' },
            borderColor: { type: 'string' },
            borderWidth: { type: 'number' },
            borderRadius: { type: 'number' },
            paddingValues: { type: 'object' },
            maxWidth: { type: 'number' }
        },
        supports: {
            html: false,
            align: ["wide", "full"],
            color: {
                background: true,
                text: true,
                link: false
            },
            spacing: {
                padding: true,
                margin: false
            },
            __experimentalBorder: {
                color: true,
                radius: true,
                width: true,
                style: false
            }
        },

        edit: function(props) {
            const { attributes, setAttributes } = props;
            const { align } = attributes;
            const blockProps = useBlockProps({ 
                style: getInlineStyles(attributes)
            });

        const TEMPLATE = [
                ['core/heading', { level: 4, placeholder: __('Card Title...', 'fca-pages') }],
                ['core/paragraph', { placeholder: __('Card content...', 'fca-pages') }]
            ];

            return el(
                wp.element.Fragment,
                {},
                el(
                    InspectorControls,
                    null,
                    el(PanelColorSettings,
                        { 
                            title: __( 'Color Settings', 'fca-pages' ),
                            initialOpen: true,
                            colorSettings: [
                                {
                                    value: attributes.backgroundColor,
                                    onChange: (value) => setAttributes({ backgroundColor: value }),
                                    label: __( 'Background Color', 'fca-pages' ),
                                },
                                {
                                    value: attributes.textColor,
                                    onChange: (value) => setAttributes({ textColor: value }),
                                    label: __( 'Text Color', 'fca-pages' ),
                                },
                                {
                                    value: attributes.borderColor,
                                    onChange: (value) => setAttributes({ borderColor: value }),
                                    label: __( 'Border Color', 'fca-pages' ),
                                },
                            ]
                        }
                    ),
                    el(PanelBody, 
                        { title: __( 'Border & Padding', 'fca-pages' ), initialOpen: false },
                        el(RangeControl, {
                            label: __( 'Border Width (px)', 'fca-pages' ),
                            value: attributes.borderWidth,
                            onChange: (value) => setAttributes({ borderWidth: value }),
                            min: 0,
                            max: 10,
                            step: 1,
                        }),
                        el(RangeControl, {
                            label: __( 'Border Radius (px)', 'fca-pages' ),
                            value: attributes.borderRadius,
                            onChange: (value) => setAttributes({ borderRadius: value }),
                            min: 0,
                            max: 50,
                            step: 1,
                        }),
                        el(__experimentalBoxControl, {
                            label: __( 'Padding', 'fca-pages' ),
                            values: attributes.paddingValues,
                            onChange: (values) => setAttributes({ paddingValues: values }),
                            units: [
                                { value: 'px', label: 'px', default: 16 },
                                { value: 'em', label: 'em', default: 1 },
                                { value: 'rem', label: 'rem', default: 1 },
                                { value: '%', label: '%', default: 5 },
                            ],
                             allowReset: true,
                        })
                    ),
                    el(PanelBody, 
                        { title: __( 'Width', 'fca-pages' ), initialOpen: false },
                        el(RangeControl, {
                            label: __( 'Max Width (px)', 'fca-pages' ),
                            value: attributes.maxWidth,
                            onChange: (value) => setAttributes({ maxWidth: value }),
                            min: 100,
                            max: 2000,
                            step: 10,
                            help: __( 'Leave blank to use theme defaults based on alignment.', 'fca-pages' )
                        })
                    )
                ),
                el(
                    'div',
                    blockProps,
                    el(InnerBlocks, {
                        template: TEMPLATE,
                        templateLock: false
                    })
                )
            );
        },

        save: function(props) {
            const { attributes } = props;
            const blockProps = useBlockProps.save({
                 style: getInlineStyles(attributes)
            });

            return el(
                'div',
                blockProps,
                el(InnerBlocks.Content, {})
            );
        }
    });
})(window.wp); 