<?php
/**
 * Template Name: FluentCommunity Page
 * Description: A page template that incorporates the FluentCommunity header and sidebar, based on fcwrapper.
 *
 * @package FluentCommunity_Mimic
 */

// --- Start: Added code based on fcwrapper/header.php ---
use FluentCommunity\App\Hooks\Handlers\PortalHandler;
use FluentCommunity\App\Models\BaseSpace;
use FluentCommunity\App\Models\Comment;
use FluentCommunity\App\Models\Feed;
use FluentCommunity\App\Models\Reaction;
use FluentCommunity\App\Models\XProfile;
use FluentCommunity\Framework\Support\Arr;

// Check if PortalHandler class exists before trying to use it
if (class_exists('FluentCommunity\App\Hooks\Handlers\PortalHandler')) {
    try {
        $portalHander = new PortalHandler();
        $data = $portalHander->getAppData();
        // Ensure loadClassicPortalAssets method exists and call it
        if (method_exists($portalHander, 'loadClassicPortalAssets')) {
            // $portalHander->loadClassicPortalAssets($data); // <-- Temporarily commented out for URL diagnosis
        } else {
            // Optional: Log or display a notice if method is missing
            error_log('FluentCommunity PortalHandler::loadClassicPortalAssets method not found.');
        }
    } catch (\Exception $e) {
        // Optional: Log or display error if instantiation fails
        error_log('Error initializing FluentCommunity PortalHandler: ' . $e->getMessage());
        wp_die('There was an error initializing the FluentCommunity integration.');
    }
} else {
    // Optional: Log or display error if class is missing
    error_log('FluentCommunity PortalHandler class not found.');
    wp_die('FluentCommunity integration class not found. Is the plugin active and updated?');
}
// --- End: Added code based on fcwrapper/header.php ---

// --- Attempt to manually inject CSS variables --- Corrected Method ---
if (class_exists('\FluentCommunity\App\Functions\Utility') && method_exists('\FluentCommunity\App\Functions\Utility', 'getColorCssVariables')) {
    $css_vars_string = \FluentCommunity\App\Functions\Utility::getColorCssVariables();
    if (!empty($css_vars_string)) {
        // The method likely returns just the CSS rules, so we wrap them
        echo '<style id="fcom_css_vars_manual">'.PHP_EOL.trim($css_vars_string).PHP_EOL.'</style>';
    } else {
         error_log('FluentCommunity Mimic Theme: Utility::getColorCssVariables() returned empty string.');
    }
} else {
    error_log('FluentCommunity Mimic Theme: \FluentCommunity\App\Functions\Utility::getColorCssVariables() method not found.');
}
// --- End attempt ---

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php 
    // We might need the CSS links from fcwrapper header.php too 
    // For now, relying on wp_head() and potentially loadClassicPortalAssets()
    ?>
    <?php wp_head(); ?>
    <?php //do_action('fluent_community/template_header'); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<?php //do_action('fluent_community/before_portal_dom'); ?>
<?php // --- Start: HTML Structure from fcwrapper/header.php --- ?>
<div class="fluent_com fcmods"> <?php // Added fcmods class from fcwrapper ?>
    <div class="fhr_wrap">
        <?php do_action('fluent_community/portal_header'); // Reverted from 'wp' argument ?>
        <div class="fhr_content">
            <div id="fluent_comminity_body" class="fhr_home">
                <div class="feed_layout">
                    <div class="spaces">
                        <div id="fluent_community_sidebar_menu" class="space_contents">
                            <?php do_action('fluent_community/portal_sidebar', 'headless'); // Reverted from 'wp' to 'headless' ?>
                        </div>
                    </div>
                    <?php // --- End: Sidebar part from fcwrapper/header.php --- ?>

                    <?php // --- Start: Content Area structure based on fcwrapper/template-sidebar.php --- ?>
                    <div class="fcom_wp_page"> <?php // Changed class from theme to differentiate ?>
                        <div class="fcom_single_layout fcom_max_layout feeds">
                            <div class="feeds_main">
                                <div class="no_bg_layout fcom_route_space_feed fhr_content_layout">
                                    <div>
                                        <div style="/* height: calc(100vh - var(--fcom-header-height, 0px); */ min-height: 80vh;"> <?php // Adjusted height style ?>
                                            <div>
                                                <div class="fhr_content_layout_header fcom_sticky_header">
                                                    <?php // Display the page title using WP function, wrapped in <a> like FC native pages ?>
                                                    <h1 class="fcom_page_title">
                                                        <a href="<?php the_permalink(); ?>" style="text-decoration: none; pointer-events: none;">
                                                            <?php the_title(); ?>
                                                        </a>
                                                    </h1>
                                                </div>
                                                <div class="fhr_content_layout_body">
                                                    <section class="el-container fcom_resp_container fcom_space_container fcom_main_container">
                                                        <main class="el-main fcom_main">
                                                            <?php // REMOVED NESTED DIVS START ?>
                                                            <?php /* 
                                                            <div class="fcom_has_space_sidebar fcom_layout_timeline fcom_route_space_feed fcom_feed_box">
                                                                <div class="space_route">
                                                                    <div class="space_holder">
                                                                        <div>
                                                                            <div class="feed_type_text feed_single feed">
                                                                                <div class="feed_body">
                                                            */ ?>                 
                                                                                    <div class="feed_texts feed_md_content">
                                                                                        <?php 
                                                                                        // Standard WordPress loop to display page content
                                                                                        if ( have_posts() ) : 
                                                                                            while ( have_posts() ) : the_post();
                                                                                                the_content(); // Display the page content
                                                                                            endwhile;
                                                                                        else:
                                                                                            echo "<p>No content found for this page.</p>";
                                                                                        endif;
                                                                                        ?>
                                                                                    </div>
                                                            <?php // REMOVED NESTED DIVS END ?>
                                                            <?php /* 
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            */ ?>
                                                        </main>
                                                        <?php /* Optional: Add aside for widgets if needed, like in fcwrapper */ ?>
                                                        <?php /* 
                                                        <aside class="el-aside fcom_resp_side" style="--el-aside-width: 306px;">
                                                            <div class="fcom_main_side_wrap">
                                                                <?php dynamic_sidebar( 'widget-area-1' ); ?>
                                                            </div>
                                                        </aside>
                                                        */ ?>
                                                    </section>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php // --- End: Content Area --- ?>

                </div> <?php // .feed_layout ?>
            </div> <?php // #fluent_comminity_body ?>
        </div> <?php // .fhr_content ?>
    </div> <?php // .fhr_wrap ?>
</div> <?php // .fluent_com ?>

<script id="custom-theme-toggle-script">
document.addEventListener('DOMContentLoaded', function() {
    const themeToggleButton = document.querySelector('button.fcom_color_mode_core');
    const htmlElement = document.documentElement;
    const iconContainer = themeToggleButton ? themeToggleButton.querySelector('.fcom_color_mode_action') : null;
    const lightIcon = iconContainer ? iconContainer.querySelector('.show_on_light') : null;
    const darkIcon = iconContainer ? iconContainer.querySelector('.show_on_dark') : null;

    const FCOM_GLOBAL_STORAGE_KEY = 'fcom_global_storage';
    const FCOM_COLOR_MODE_PROPERTY = 'fcom_color_mode'; // Assuming this is the property name

    const getThemeFromGlobalStorage = () => {
        try {
            const globalStorageStr = localStorage.getItem(FCOM_GLOBAL_STORAGE_KEY);
            if (globalStorageStr) {
                const globalStorage = JSON.parse(globalStorageStr);
                return globalStorage[FCOM_COLOR_MODE_PROPERTY] || 'light';
            }
        } catch (e) {
            console.warn('FluentCommunity Mimic Theme: Error reading global storage for theme:', e);
        }
        return 'light'; // Default theme
    };

    const setThemeInGlobalStorage = (theme) => {
        try {
            let globalStorage = {};
            const globalStorageStr = localStorage.getItem(FCOM_GLOBAL_STORAGE_KEY);
            if (globalStorageStr) {
                try {
                    globalStorage = JSON.parse(globalStorageStr);
                } catch (e) {
                    console.warn('FluentCommunity Mimic Theme: Could not parse existing global storage, will overwrite.', e);
                    globalStorage = {}; // Reset if unparseable
                }
            }
            globalStorage[FCOM_COLOR_MODE_PROPERTY] = theme;
            localStorage.setItem(FCOM_GLOBAL_STORAGE_KEY, JSON.stringify(globalStorage));
        } catch (e) {
            console.error('FluentCommunity Mimic Theme: Error writing global storage for theme:', e);
        }
    };

    const applyThemeToDOM = (theme) => {
        htmlElement.classList.remove('light', 'dark');
        htmlElement.classList.add(theme);
        htmlElement.dataset.colorMode = theme;

        if (iconContainer && lightIcon && darkIcon) {
            iconContainer.style.display = '';
            lightIcon.style.display = theme === 'light' ? '' : 'none';
            darkIcon.style.display = theme === 'dark' ? '' : 'none';
        }
    };

    // Initialize theme on load
    const initialTheme = getThemeFromGlobalStorage();
    applyThemeToDOM(initialTheme);

    if (themeToggleButton) {
        themeToggleButton.addEventListener('click', function(event) {
            event.preventDefault();
            event.stopPropagation();
            const currentDOMTheme = htmlElement.classList.contains('dark') ? 'dark' : 'light';
            const newTheme = currentDOMTheme === 'dark' ? 'light' : 'dark';
            
            applyThemeToDOM(newTheme); // Apply visually immediately
            setThemeInGlobalStorage(newTheme); // Set in localStorage, which will trigger 'storage' event
        });
    } else {
        console.warn('FluentCommunity Mimic Theme: Theme toggle button not found.');
    }

    // Listen for changes to fcom_global_storage from other pages
    window.addEventListener('storage', function(event) {
        if (event.key === FCOM_GLOBAL_STORAGE_KEY) {
            const themeFromStorageEvent = getThemeFromGlobalStorage(); // Re-read and parse the whole storage
            const currentDOMTheme = htmlElement.classList.contains('dark') ? 'dark' : 'light';
            if (themeFromStorageEvent !== currentDOMTheme) {
                applyThemeToDOM(themeFromStorageEvent);
            }
        }
    });
});
</script>

<?php wp_footer(); // Standard WordPress footer hooks ?>
<?php //do_action('fluent_community/template_footer'); ?>
</body>
</html> 