/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 * Handles settings defined in functions.php with 'transport' => 'postMessage'.
 */

( function( $ ) {

	// --- Standard Header Styles ---

	// Header Background Color
	wp.customize( 'fc_theme_header_bg_color', function( value ) {
		value.bind( function( newval ) {
			$( 'body.wp-standard-view .fcom_top_menu' ).css( '--fcom-primary-bg', newval );
		} );
	} );

	// Header Border Color
	wp.customize( 'fc_theme_header_border_color', function( value ) {
		value.bind( function( newval ) {
			$( 'body.wp-standard-view .fcom_top_menu' ).css( '--fcom-primary-border', newval );
		} );
	} );

	// Header Menu Text Color
	wp.customize( 'fc_theme_header_menu_text_color', function( value ) {
		value.bind( function( newval ) {
			$( 'body.wp-standard-view .fcom_top_menu' ).css( '--fcom-menu-text', newval );
            // Need to update specific elements if they don't inherit directly
            // e.g., site title link, user name, login/register links
             $( 'body.wp-standard-view .fcom_top_menu .fhr_logo .standard-site-title a' ).css( 'color', newval );
             $( 'body.wp-standard-view .fcom_top_menu .top_menu_right .standard-login-item .user_name' ).css( 'color', newval );
             $( 'body.wp-standard-view .fcom_top_menu .top_menu_right .standard-login-item > a' ).css( 'color', newval ); // Direct links like Login/Register
		} );
	} );

    // Header Menu Text Hover/Active Color
	wp.customize( 'fc_theme_header_menu_text_hover_color', function( value ) {
		value.bind( function( newval ) {
			$( 'body.wp-standard-view .fcom_top_menu' ).css( '--fcom-menu-text-hover', newval );
			$( 'body.wp-standard-view .fcom_top_menu' ).css( '--fcom-menu-text-active', newval );
            // Need to update hover state for specific non-menu items if needed
             // $( 'body.wp-standard-view .fcom_top_menu .top_menu_right .standard-login-item > a:hover' ).css( 'color', newval ); // This is hard with just CSS vars
		} );
	} );

    // Header Menu Background Hover/Active Color
	wp.customize( 'fc_theme_header_menu_bg_hover_color', function( value ) {
		value.bind( function( newval ) {
			$( 'body.wp-standard-view .fcom_top_menu' ).css( '--fcom-menu-bg-hover', newval );
			$( 'body.wp-standard-view .fcom_top_menu' ).css( '--fcom-active-bg', newval );
		} );
	} );

    // --- Standard Page Layout ---

    // Standard Content Max Width
    wp.customize( 'fc_theme_standard_content_max_width', function( value ) {
        value.bind( function( newval ) {
            var primaryContent = $( 'body.wp-standard-view .standard-content-wrapper.layout-no-sidebar > #primary' );
            if ( newval && parseInt( newval, 10 ) > 0 ) {
                primaryContent.css( {
                    'max-width': newval + 'px',
                    'margin-left': 'auto',
                    'margin-right': 'auto'
                } );
            } else {
                primaryContent.css( {
                    'max-width': 'none',
                    'margin-left': '', // Reset margin
                    'margin-right': '' // Reset margin
                } );
            }
            // Note: Handling width when sidebar is active might need more complex logic
            // depending on the desired layout (e.g., calculating width based on sidebar).
            // Current CSS handles the no-sidebar case simply.
        } );
    } );


	// --- FluentCommunity Template Layout ---

	// FC Template Content Max Width
	wp.customize( 'fc_template_content_max_width', function( value ) {
		value.bind( function( newval ) {
            var targetElement = $( '.fcom_wp_page .fhr_content_layout_body .el-main.fcom_main' );
			if ( newval && parseInt( newval, 10 ) > 0 ) {
				targetElement.css( {
                    'max-width': newval + 'px',
                    'margin-left': 'auto',
                    'margin-right': 'auto'
                } );
			} else {
				targetElement.css( {
                    'max-width': 'none',
                    'margin-left': '',
                    'margin-right': ''
                } );
			}
		} );
	} );

	// FC Template Content Padding
	wp.customize( 'fc_template_content_padding', function( value ) {
		value.bind( function( newval ) {
            var targetElement = $( '.fcom_wp_page .fhr_content_layout_body' );
            if ( newval && parseInt( newval, 10 ) >= 0 ) { // Allow 0 padding
                 targetElement.css( 'padding', newval + 'px' );
            } else {
                 targetElement.css( 'padding', '' ); // Reset to CSS default
            }

		} );
	} );

    // FC Template Content Background Color
	wp.customize( 'fc_template_content_bg_color', function( value ) {
		value.bind( function( newval ) {
			$( '.fcom_wp_page .fhr_content_layout_body' ).css( 'background-color', newval );
		} );
	} );


} )( jQuery ); 