<?php
/**
 * The header for standard WordPress pages in our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 * It mimics the FluentCommunity header structure but uses standard WP navigation.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package FluentCommunity_Theme
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php
        // --- Attempt to manually inject CSS variables --- Needed for header styling
        if (class_exists('\FluentCommunity\App\Functions\Utility') && method_exists('\FluentCommunity\App\Functions\Utility', 'getColorCssVariables')) {
            $css_vars_string = \FluentCommunity\App\Functions\Utility::getColorCssVariables();
            if (!empty($css_vars_string)) {
                echo '<style id="fcom_css_vars_manual">'.PHP_EOL.trim($css_vars_string).PHP_EOL.'</style>';
            } else {
                error_log('FluentCommunity Theme: Utility::getColorCssVariables() returned empty string in header.php.');
            }
        } else {
            error_log('FluentCommunity Theme: \FluentCommunity\App\Functions\Utility::getColorCssVariables() method not found in header.php.');
        }
        // --- End attempt ---
    ?>
	<?php wp_head(); ?>
</head>
<body <?php body_class( 'wp-standard-view' ); // Class for standard WP views ?>>
<?php wp_body_open(); ?>

<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'fluentcommunity-theme' ); ?></a>

<?php // --- Start: Fluent Community Header Structure --- ?>
<div class="fcom_top_menu">
    <div class="top_menu_left">
        <?php /* --- Space Opener Button (Optional - Consider adding via Customizer) ---
        <div class="space_opener">
            <button aria-label="Open Menu" class="fcom_space_opener_btn" style="background-color: transparent; cursor: pointer; border: 0 solid transparent;color: #5d5e61;" aria-disabled="false" type="button">
                <span>
                    <i class="el-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" color="currentColor" fill="none">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M3 4.5C3 3.94772 3.44772 3.5 4 3.5L20 3.5C20.5523 3.5 21 3.94772 21 4.5C21 5.05229 20.5523 5.5 20 5.5L4 5.5C3.44772 5.5 3 5.05228 3 4.5Z" fill="currentColor"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M3 14.5C3 13.9477 3.44772 13.5 4 13.5L20 13.5C20.5523 13.5 21 13.9477 21 14.5C21 15.0523 20.5523 15.5 20 15.5L4 15.5C3.44772 15.5 3 15.0523 3 14.5Z" fill="currentColor"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M3 9.5C3 8.94772 3.44772 8.5 4 8.5L20 8.5C20.5523 8.5 21 8.94772 21 9.5C21 10.0523 20.5523 10.5 20 10.5L4 10.5C3.44772 10.5 3 10.0523 3 9.5Z" fill="currentColor"></path>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M3 19.5C3 18.9477 3.44772 18.5 4 18.5L20 18.5C20.5523 18.5 21 18.9477 21 19.5C21 20.0523 20.5523 20.5 20 20.5L4 20.5C3.44772 20.5 3 20.0523 3 19.5Z" fill="currentColor"></path>
                        </svg>
                    </i>
                </span>
            </button>
        </div>
        --- */ ?>
        <div id="fcom_before_logo"></div>
        <div class="fhr_logo">
             <?php
                $logo_display = get_theme_mod( 'fc_theme_header_logo_display', 'logo_and_title' ); // Default: show both
                $has_logo = has_custom_logo();
                $has_fc_logo = function_exists('FluentCommunity') && method_exists(FluentCommunity(), 'getSetting') && FluentCommunity()->getSetting('logo');
                $has_title = get_bloginfo( 'name' );

                $show_logo = ($logo_display === 'logo_only' || $logo_display === 'logo_and_title');
                $show_title = ($logo_display === 'title_only' || $logo_display === 'logo_and_title');

                // Use WP custom logo or fallback to FC logo setting or Site Title
                if ( $show_logo && $has_logo ) {
                    the_custom_logo();
                } else if ( $show_logo && $has_fc_logo ) {
                    $fc_logo_light = FluentCommunity()->getSetting('logo');
                    $fc_logo_dark = FluentCommunity()->getSetting('logo_dark', $fc_logo_light);
                    $site_title = get_bloginfo( 'name' );
                    ?>
                    <a class="fcom_route" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <img class="show_on_light" src="<?php echo esc_url($fc_logo_light); ?>" alt="<?php echo esc_attr($site_title); ?>">
                        <?php if ($fc_logo_dark): ?>
                            <img class="show_on_dark" src="<?php echo esc_url($fc_logo_dark); ?>" alt="<?php echo esc_attr($site_title); ?>">
                        <?php endif; ?>
                    </a>
                    <?php
                }

                // Display Site Title if enabled and no logo is displayed (or if both are enabled)
                if ( $show_title && $has_title && (!$show_logo || !$has_logo && !$has_fc_logo || $logo_display === 'logo_and_title') ) {
                    ?>
                    <h1 class="standard-site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                    <?php
                }
            ?>
        </div>
    </div>
    <div class="top_menu_center fcom_desktop_only fcom_general_menu">
        <nav id="standard-site-navigation" class="standard-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Header Menu', 'fluentcommunity-theme' ); ?>">
            <?php
            // Use the 'fcom-header-menu' location we will register in functions.php
            // Keep the customizer setting as a fallback for now
            $menu_id = get_theme_mod('fc_theme_standard_header_menu', '');
            $theme_location = 'fcom-header-menu'; // Define the new location

            if ( has_nav_menu( $theme_location ) ) {
                 wp_nav_menu(
                     array(
                         'theme_location' => $theme_location,
                         'menu_class'     => 'fcom_header_menu top_menu_items', // Use FC classes
                         'container'      => false, // Don't wrap in extra div
                         'items_wrap'     => '<ul aria-label="Main menu" class="%2$s">%3$s</ul>', // Match FC structure
                         'depth'          => 1, // Keep it simple, 1 level deep
                         'fallback_cb'    => false,
                         // Custom walker might be needed for icons if desired
                     )
                 );
            } elseif (!empty($menu_id) && has_nav_menu( 'secondary-header-menu' )) {
                 // Fallback to old method if new location isn't set up yet
                  wp_nav_menu(
                      array(
                          'theme_location' => 'secondary-header-menu',
                          'menu'           => $menu_id,
                          'menu_class'     => 'fcom_header_menu top_menu_items',
                          'container'      => false,
                          'items_wrap'     => '<ul aria-label="Main menu" class="%2$s">%3$s</ul>',
                          'depth'          => 1,
                          'fallback_cb'    => false,
                      )
                  );
            } else {
                // Optional: Instructions if no menu is found/selected
                 echo '<ul aria-label="Main menu" class="fcom_header_menu top_menu_items"><li><a href="#">' . esc_html__('Assign a menu in Appearance > Menus or Customizer', 'fluentcommunity-theme') . '</a></li></ul>';
            }
            ?>
        </nav><!-- #site-navigation -->
    </div>
    <div class="top_menu_right">
        <ul class="fcom_user_context_menu_items">
            <?php // --- Search (Optional - Consider adding via Customizer/Widget) ---
            /*
            <li class="top_menu_item fcom_search_holder"><button aria-disabled="false" type="button" class="el-button el-button--small is-text"><span class=""><i class="el-icon fcom_search_icon" id="fcom_search_icon"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1024 1024"><path fill="currentColor" d="m795.904 750.72 124.992 124.928a32 32 0 0 1-45.248 45.248L750.656 795.904a416 416 0 1 1 45.248-45.248zM480 832a352 352 0 1 0 0-704 352 352 0 0 0 0 704"></path></svg></i></span></button></li>
            */ ?>
            <?php // --- Notifications (FC Specific - Generally won't work in standard WP context) ---
            /*
            <li class="top_menu_item fcom_notification_holder">...</li>
            */ ?>
             <?php // --- Messages (FC Specific - Generally won't work in standard WP context) ---
            /*
            <li class="top_menu_item fcom_better_messages_menu_li fcom_desktop_only">...</li>
            */ ?>
            <?php // --- Standard WP User Actions --- ?>
            <?php // Example: get_search_form(); could be placed here if needed.
            ?>
        </ul>
    </div>
</div>
<?php // --- End: Fluent Community Header Structure --- ?>

<?php // Determine if sidebar should be shown based on Customizer setting
$show_sidebar = get_theme_mod('fc_theme_display_sidebar_standard', false);
?>

<div id="page" class="site <?php echo $show_sidebar ? 'has-fc-sidebar' : 'no-fc-sidebar'; ?>">
    <div class="standard-content-wrapper <?php echo $show_sidebar ? 'layout-with-sidebar' : 'layout-no-sidebar'; ?>">
        <?php if ($show_sidebar && function_exists('do_action')): // Check if function exists before calling ?>
            <div class="spaces standard-sidebar"> <?php // Use FC class for potential styling ?>
                 <div id="fluent_community_sidebar_menu" class="space_contents">
                    <?php do_action('fluent_community/portal_sidebar', 'headless'); ?>
                 </div>
            </div>
        <?php endif; ?>

        <div id="primary" class="content-area <?php echo $show_sidebar ? 'content-with-sidebar' : 'content-no-sidebar'; ?>">
            <main id="main" class="site-main" role="main">

<?php // Note: The standard loop will start in index.php, page.php, single.php etc. ?>