(function() {
    // console.log('FCA: Widget System Loading - v1.0');
    // console.log('FCA: Current URL:', window.location.href);
    // console.log('FCA: Current Path:', window.location.pathname);

    function initWidgetSystem() {
        // Log Vue app status
        // console.log('FCA: Checking for FluentCommunityApp...');
        // console.log('FCA: FluentCommunityApp exists:', typeof window.FluentCommunityApp !== 'undefined');

        if (typeof window.FluentCommunityApp === 'undefined') {
            // console.log('FCA: FluentCommunityApp not found, retrying in 500ms');
            setTimeout(initWidgetSystem, 500);
            return;
        }

        // Log DOM elements we're looking for
        const sidebarSelectors = ['.fc_space_sidebar', '.fc_sidebar', '.app_sidebar'];
        sidebarSelectors.forEach(selector => {
            const element = document.querySelector(selector);
            // console.log('FCA: Looking for', selector, ':', element ? 'Found' : 'Not found');
        });

        // Register widget component
        // console.log('FCA: Registering hello-widget component');
        window.FluentCommunityApp.component('fce-hello-widget', {
            template: `
                <div class="app_side_widget" style="margin: 20px 0; padding: 15px; background: var(--fcom-primary-bg, #ffffff); border-radius: 8px;">
                    <h3>Hello World Widget</h3>
                    <p>Test widget in Vue component (v1.0)</p>
                </div>
            `
        });

        // Watch for sidebar changes
        // console.log('FCA: Setting up MutationObserver');
        const observer = new MutationObserver((mutations) => {
            // console.log('FCA: DOM mutation detected');
            const sidebar = document.querySelector('.fc_space_sidebar, .fc_sidebar, .app_sidebar');
            if (sidebar) {
                // console.log('FCA: Found sidebar after mutation');
                injectWidgets(sidebar);
            } else {
                // console.log('FCA: No sidebar found after mutation');
            }
        });

        observer.observe(document.body, {
            childList: true,
            subtree: true
        });
        // console.log('FCA: MutationObserver started');
    }

    function injectWidgets(sidebar) {
        // console.log('FCA: Attempting to inject widget into:', sidebar);
        if (!sidebar.querySelector('#fce-hello-widget')) {
            // console.log('FCA: Creating widget mount point');
            const widgetMount = document.createElement('div');
            widgetMount.id = 'fce-hello-widget';
            widgetMount.innerHTML = '<fce-hello-widget></fce-hello-widget>';
            sidebar.insertBefore(widgetMount, sidebar.firstChild);
            // console.log('FCA: Widget mounted successfully');
        } else {
            // console.log('FCA: Widget already exists');
        }
    }

    // Start initialization
    // console.log('FCA: Checking document ready state:', document.readyState);
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initWidgetSystem);
        // console.log('FCA: Waiting for DOMContentLoaded');
    } else {
        // console.log('FCA: Document already loaded, initializing now');
        initWidgetSystem();
    }
})(); 