/**
 * FCA Menu Item Integration
 * 
 * We don't need any JavaScript anymore.
 * The FluentCommunity Vue router will recognize our menu items 
 * because we've added the proper space/course/page ID and slug classes.
 */ 

/**
 * FCA Active Menu - Diagnostic Version
 */

// Immediately log to console to verify script is loading
console.log('FCA Active Menu script loaded!');

// Wait for document to be ready
document.addEventListener('DOMContentLoaded', function() {
    console.log('FCA Active Menu: DOM Content Loaded');
    
    // Check if jQuery is available
    if (typeof jQuery === 'undefined') {
        console.error('FCA Active Menu: jQuery is not available!');
        return;
    }

    console.log('FCA Active Menu: jQuery is available');
    
    // Wrap everything in try-catch to identify errors
    try {
        // Self-executing function for jQuery
        (function($) {
            console.log('FCA Active Menu: Starting menu item activation');
            
            // Simple function to add active class to matching links
            function activateMenuItems() {
                // Get current URL
                var currentUrl = window.location.href;
                console.log('FCA Active Menu: Current URL is', currentUrl);
                
                // Get all menu items
                var menuItems = document.querySelectorAll('.fca-widget-menu-item');
                console.log('FCA Active Menu: Found', menuItems.length, 'menu items');

                // Check each menu item
                for (var i = 0; i < menuItems.length; i++) {
                    var menuItem = menuItems[i];
                    var href = menuItem.getAttribute('href');

                    if (href && currentUrl.indexOf(href) !== -1) {
                        console.log('FCA Active Menu: Match found for', href);
                        menuItem.classList.add('router-link-exact-active');
                        menuItem.classList.add('active');
                    }
                }
            }
            
            // Run immediately and after a delay
            activateMenuItems();
            setTimeout(activateMenuItems, 1000);
            
            // Set up click listeners on sidebar links
            $(document).on('click', '#fcom_sidebar_wrap a', function() {
                console.log('FCA Active Menu: Link clicked');
                setTimeout(activateMenuItems, 500);
            });
            
            // Check periodically
            setInterval(activateMenuItems, 2000);
            
        })(jQuery);
    } catch (error) {
        console.error('FCA Active Menu: Error occurred:', error);
    }
});

// Also attach to window.onload as a backup
window.onload = function() {
    console.log('FCA Active Menu: Window loaded');
    
    // Check if our main script already ran
    if (document.querySelector('.fca-widget-menu-item.router-link-exact-active')) {
        console.log('FCA Active Menu: Menu items already activated');
        return;
    }
    
    // If not, run a simple check
    try {
        var currentUrl = window.location.href;
        var menuItems = document.querySelectorAll('.fca-widget-menu-item');
        
        console.log('FCA Active Menu (onload): Current URL is', currentUrl);
        console.log('FCA Active Menu (onload): Found', menuItems.length, 'menu items');
        
        for (var i = 0; i < menuItems.length; i++) {
            var menuItem = menuItems[i];
            var href = menuItem.getAttribute('href');
            
            if (href && currentUrl.indexOf(href) !== -1) {
                console.log('FCA Active Menu (onload): Match found for', href);
                menuItem.classList.add('router-link-exact-active');
                menuItem.classList.add('active');
            }
        }
    } catch (error) {
        console.error('FCA Active Menu (onload): Error occurred:', error);
        }
}; 