<?php
/**
 * Plugin Name: FCA Widgets
 * Plugin URI: https://www.fluentcommunityaddons.com
 * Description: Custom widgets for FluentCommunity
 * Version: 1.0.8
 * Author: Fluent Community Add-ons
 * Author URI: https://www.fluentcommunityaddons.com
 * Text Domain: fca-widgets
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('FCA_WIDGETS_VERSION', '1.0.8');
define('FCA_WIDGETS_PLUGIN_FILE', __FILE__);
define('FCA_WIDGETS_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('FCA_WIDGETS_PLUGIN_URL', plugin_dir_url(__FILE__));

// Add version check system
function fca_widgets_check_version() {
    $stored_version = get_option('fca_widgets_version', '0');
    if ($stored_version !== FCA_WIDGETS_VERSION) {
        // Run migration function (will be defined in class-migration-manager.php)
        do_action('fca_widgets_version_updated', $stored_version, FCA_WIDGETS_VERSION);
        // Update stored version
        update_option('fca_widgets_version', FCA_WIDGETS_VERSION);
    }
}
add_action('plugins_loaded', 'fca_widgets_check_version', 1); // Run before the main plugin init

// Include required files
require_once FCA_WIDGETS_PLUGIN_DIR . 'includes/class-widget-manager.php';
require_once FCA_WIDGETS_PLUGIN_DIR . 'includes/class-sidebar-menu-manager.php';
require_once FCA_WIDGETS_PLUGIN_DIR . 'includes/class-migration-manager.php'; // Add migration manager class

// Initialize the plugin
function fca_widgets_init() {
    // Create admin menu
    add_action('admin_menu', 'fca_widgets_admin_menu');
    
    // Initialize widget manager
    $widget_manager = new FCA_WidgetManager();
    
    // Initialize sidebar menu manager
    $sidebar_menu_manager = new FCA_SidebarMenuManager();
    
    // Inject active menu script into portal footer
    add_action('fluent_community/portal_footer', 'fca_widgets_inject_footer_scripts');
}
add_action('plugins_loaded', 'fca_widgets_init');

/**
 * Enqueue frontend scripts - REMOVED
 */
/*
function fca_widgets_enqueue_frontend_scripts() {
    // ... function content removed ...
}
*/

/**
 * Add inline styling directly to the head for immediate effect - REMOVED
 */
/*
function fca_add_direct_menu_styling() {
    // ... function content removed ...
}
*/

/**
 * Inject scripts into the FluentCommunity portal footer.
 */
function fca_widgets_inject_footer_scripts() {
    ?>
    <script id="fca-active-menu-script">
    /* FCA Active Menu - Production Version */
    (function() {
        // Function to handle active states for page and custom menu links
        function makeMenuItemsActive() {
            var currentUrl = window.location.href;
            var normalizedCurrentUrl = currentUrl.replace(/\/?([?#].*)?$/, ''); // Normalize current URL

            var menuItems = document.querySelectorAll('.fca-widget-menu-item'); 
            
            for (var i = 0; i < menuItems.length; i++) {
                var menuItem = menuItems[i];
                var href = menuItem.getAttribute('href');
                
                if (!href) continue;
                
                var normalizedHref = href.replace(/\/?([?#].*)?$/, ''); // Normalize link href
                
                // Check if the normalized current URL *starts with* the normalized href.
                // This allows matching for WP pages even if query strings or hashes are present on the current URL.
                // It also continues to work for exact SPA route matches after normalization.
                if (normalizedCurrentUrl.startsWith(normalizedHref)) {
                    menuItem.classList.add('router-link-exact-active');
                } else {
                    menuItem.classList.remove('router-link-exact-active');
                }
            }
        }
        
        // Wait for FluentCommunity utilities to be ready
        document.addEventListener('fluentCommunityUtilReady', function() {
            if (!window.FluentCommunityUtil || !window.FluentCommunityUtil.hooks) {
                // Fallback to simple event listeners if hooks not available
                window.addEventListener('hashchange', makeMenuItemsActive);
                window.addEventListener('popstate', makeMenuItemsActive);
                makeMenuItemsActive();
                return;
            }
            
            // Use FluentCommunity's hooks system
            window.FluentCommunityUtil.hooks.addAction('fluent_com_route_changed', 'fca_active_menu', function() {
                setTimeout(makeMenuItemsActive, 50);
            });
            
            // Listen directly to router events if possible
            if (window.FluentCommunityUtil.router) {
                window.FluentCommunityUtil.router.afterEach(function() {
                    setTimeout(makeMenuItemsActive, 50);
                });
            }
            
            // Initial check
            setTimeout(makeMenuItemsActive, 100);
        });
        
        // Basic DOM ready handler
        function domReady() {
            makeMenuItemsActive();
            
            // Capture click events for immediate feedback
            document.addEventListener('click', function(e) {
                // Check if the clicked element or its ancestor is a menu item link
                if (e.target && e.target.closest('.fca-widget-menu-item')) {
                    setTimeout(makeMenuItemsActive, 100);
                }
            });
        }
        
        // Initialize when DOM is ready
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', domReady);
        } else {
            domReady();
        }
        
        // One final check on window load
        window.addEventListener('load', function() {
            makeMenuItemsActive();
            setTimeout(makeMenuItemsActive, 500);
        });
    })();
    </script>
    <?php
}

// Create admin menu
function fca_widgets_admin_menu() {
    add_menu_page(
        'FCA Widgets',
        'FCA Widgets',
        'manage_options',
        'fca-widgets',
        'fca_widgets_admin_page',
        'dashicons-layout',
        30
    );
    
    add_submenu_page(
        'fca-widgets',
        'Widget Manager',
        'Widget Manager',
        'manage_options',
        'fca-widgets-manager',
        'fca_widgets_manager_page'
    );
    
    add_submenu_page(
        'fca-widgets',
        'Sidebar Menu',
        'Sidebar Menu',
        'manage_options',
        'fca-sidebar-menu',
        'fca_sidebar_menu_page'
    );
}

// Admin page callback
function fca_widgets_admin_page() {
    ?>
    <div class="wrap">
        <h1>FluentCommunity Add-ons</h1>
        
        <div class="fca-welcome-panel">
            <div class="fca-welcome-header">
                <h2>Welcome to FluentCommunity Add-ons!</h2>
                <p class="about-description">Enhance your FluentCommunity experience with these powerful add-ons.</p>
            </div>
            
            <div class="fca-welcome-columns">
                <div class="fca-welcome-column">
                    <div class="fca-welcome-column-inner">
                        <h3><span class="dashicons dashicons-layout"></span> Widget Manager</h3>
                        <p>Create and manage custom widgets for your FluentCommunity portal.</p>
                        <a class="button button-primary" href="<?php echo admin_url('admin.php?page=fca-widgets-manager'); ?>">Manage Widgets</a>
                    </div>
                </div>
                
                <div class="fca-welcome-column">
                    <div class="fca-welcome-column-inner">
                        <h3><span class="dashicons dashicons-menu"></span> Sidebar Menu</h3>
                        <p>Customize the sidebar menu in your FluentCommunity portal.</p>
                        <a class="button button-primary" href="<?php echo admin_url('admin.php?page=fca-sidebar-menu'); ?>">Manage Sidebar Menu</a>
                    </div>
                </div>
                
                <div class="fca-welcome-column">
                    <div class="fca-welcome-column-inner">
                        <h3><span class="dashicons dashicons-sos"></span> Need Help?</h3>
                        <p>Visit our website for documentation and support.</p>
                        <a class="button button-primary" href="https://www.fluentcommunityaddons.com" target="_blank">Visit Website</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <style>
        .fca-welcome-panel {
            background: #fff;
            border: 1px solid #c3c4c7;
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.04);
            margin-top: 20px;
            padding: 0;
            border-radius: 4px;
            overflow: hidden;
        }
        
        .fca-welcome-header {
            background: #f0f6fc;
            border-bottom: 1px solid #c3c4c7;
            padding: 20px 30px;
        }
        
        .fca-welcome-header h2 {
            margin: 0 0 10px;
            font-size: 24px;
            font-weight: 400;
            line-height: 1.3;
        }
        
        .fca-welcome-header p {
            margin: 0;
            font-size: 16px;
            color: #646970;
        }
        
        .fca-welcome-columns {
            display: flex;
            flex-wrap: wrap;
            padding: 20px;
            gap: 20px;
        }
        
        .fca-welcome-column {
            flex: 1;
            min-width: 250px;
        }
        
        .fca-welcome-column-inner {
            background: #f6f7f7;
            border: 1px solid #dcdcde;
            border-radius: 4px;
            padding: 20px;
            height: 100%;
            box-sizing: border-box;
        }
        
        .fca-welcome-column h3 {
            margin-top: 0;
            display: flex;
            align-items: center;
            font-size: 16px;
            color: #1d2327;
        }
        
        .fca-welcome-column h3 .dashicons {
            margin-right: 10px;
            color: #2271b1;
        }
        
        .fca-welcome-column p {
            margin-bottom: 20px;
            color: #50575e;
            min-height: 40px;
        }
        
        @media screen and (max-width: 782px) {
            .fca-welcome-columns {
                flex-direction: column;
            }
        }
    </style>
    <?php
}

// Widget manager page callback
function fca_widgets_manager_page() {
    $widget_manager = new FCA_WidgetManager();
    $widget_manager->render_admin_page();
}

// Sidebar menu page callback
function fca_sidebar_menu_page() {
    $sidebar_menu_manager = new FCA_SidebarMenuManager();
    $sidebar_menu_manager->render_admin_page();
} 