<?php
// Prevent direct access
defined('ABSPATH') or die('No direct script access allowed');
?>

<div class="fca-cm-wrap">
    <!-- Header -->
    <div class="fca-cm-header">
        <div class="fca-cm-header-content">
            <div>
                <h1 class="fca-cm-page-title">
                    <span class="dashicons dashicons-admin-multisite"></span>
                    <?php _e('Spaces Manager', 'fca-content-manager'); ?>
                </h1>
                <p class="fca-cm-page-description">
                    <?php _e('Manage all community spaces (excluding courses)', 'fca-content-manager'); ?>
                </p>
            </div>
            <div class="fca-cm-header-actions">
                <button type="button" class="fca-cm-btn fca-cm-btn-secondary" id="fca-cm-refresh-spaces">
                    <span class="dashicons dashicons-update"></span>
                    <?php _e('Refresh', 'fca-content-manager'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="fca-cm-content">
        <div class="fca-cm-split-view">
            <!-- Left Panel: Spaces List -->
            <div class="fca-cm-list-panel">
                <!-- Filters and Search -->
                <div class="fca-cm-filters">
                    <div class="fca-cm-search-box">
                        <span class="dashicons dashicons-search"></span>
                        <input type="text" 
                               id="fca-cm-space-search" 
                               class="fca-cm-search-input" 
                               placeholder="<?php esc_attr_e('Search spaces...', 'fca-content-manager'); ?>">
                    </div>
                    
                    <div class="fca-cm-filter-row">
                        <select id="fca-cm-space-status" class="fca-cm-filter-select">
                            <option value=""><?php _e('All Statuses', 'fca-content-manager'); ?></option>
                            <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                            <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                            <option value="archived"><?php _e('Archived', 'fca-content-manager'); ?></option>
                        </select>
                        
                        <select id="fca-cm-space-privacy" class="fca-cm-filter-select">
                            <option value=""><?php _e('All Privacy', 'fca-content-manager'); ?></option>
                            <option value="public"><?php _e('Public', 'fca-content-manager'); ?></option>
                            <option value="private"><?php _e('Private', 'fca-content-manager'); ?></option>
                        </select>
                        
                        <select id="fca-cm-space-per-page" class="fca-cm-filter-select">
                            <option value="20">20 <?php _e('per page', 'fca-content-manager'); ?></option>
                            <option value="50">50 <?php _e('per page', 'fca-content-manager'); ?></option>
                            <option value="100">100 <?php _e('per page', 'fca-content-manager'); ?></option>
                        </select>
                    </div>
                </div>

                <!-- Bulk Actions -->
                <div class="fca-cm-bulk-actions">
                    <input type="checkbox" id="fca-cm-select-all-spaces" />
                    <button type="button" class="fca-cm-btn fca-cm-btn-sm fca-cm-btn-secondary" id="fca-cm-bulk-edit-spaces" disabled>
                        <span class="dashicons dashicons-edit"></span>
                        <?php _e('Bulk Edit', 'fca-content-manager'); ?>
                    </button>
                    <span class="fca-cm-selected-count"></span>
                </div>

                <!-- Spaces List -->
                <div class="fca-cm-list-container" id="fca-cm-spaces-list">
                    <div class="fca-cm-loading">
                        <span class="fca-cm-spinner"></span>
                        <p><?php _e('Loading spaces...', 'fca-content-manager'); ?></p>
                    </div>
                </div>

                <!-- Pagination -->
                <div class="fca-cm-pagination" id="fca-cm-spaces-pagination"></div>
            </div>

            <!-- Right Panel: Space Details -->
            <div class="fca-cm-detail-panel">
                <div class="fca-cm-detail-empty">
                    <span class="dashicons dashicons-admin-multisite"></span>
                    <p><?php _e('Select a space to view and edit details', 'fca-content-manager'); ?></p>
                </div>

                <div class="fca-cm-detail-content" style="display: none;">
                    <div class="fca-cm-detail-header">
                        <h2 id="fca-cm-space-title"><?php _e('Space Details', 'fca-content-manager'); ?></h2>
                        <button type="button" class="fca-cm-btn fca-cm-btn-primary" id="fca-cm-save-space">
                            <span class="dashicons dashicons-saved"></span>
                            <?php _e('Save Changes', 'fca-content-manager'); ?>
                        </button>
                    </div>

                    <div class="fca-cm-detail-body">
                        <input type="hidden" id="fca-cm-space-id">
                        
                        <!-- Title -->
                        <div class="fca-cm-form-group">
                            <label for="fca-cm-space-title-input"><?php _e('Space Title', 'fca-content-manager'); ?></label>
                            <input type="text" id="fca-cm-space-title-input" class="fca-cm-form-control">
                        </div>

                        <!-- Slug -->
                        <div class="fca-cm-form-group">
                            <label for="fca-cm-space-slug"><?php _e('Slug', 'fca-content-manager'); ?></label>
                            <input type="text" id="fca-cm-space-slug" class="fca-cm-form-control">
                        </div>

                        <!-- Description -->
                        <div class="fca-cm-form-group">
                            <label for="fca-cm-space-description"><?php _e('Description', 'fca-content-manager'); ?></label>
                            <textarea id="fca-cm-space-description" class="fca-cm-form-control" rows="5"></textarea>
                        </div>

                        <!-- Short Description -->
                        <div class="fca-cm-form-group">
                            <label for="fca-cm-space-short-description"><?php _e('Short Description', 'fca-content-manager'); ?></label>
                            <input type="text" id="fca-cm-space-short-description" class="fca-cm-form-control">
                        </div>

                        <!-- Logo URL -->
                        <div class="fca-cm-form-group">
                            <label for="fca-cm-space-logo"><?php _e('Logo URL', 'fca-content-manager'); ?></label>
                            <input type="url" id="fca-cm-space-logo" class="fca-cm-form-control" placeholder="https://...">
                            <p class="fca-cm-field-hint"><?php _e('URL to the space logo/icon image', 'fca-content-manager'); ?></p>
                        </div>

                        <!-- Cover Photo URL -->
                        <div class="fca-cm-form-group">
                            <label for="fca-cm-space-cover-photo"><?php _e('Cover Photo URL', 'fca-content-manager'); ?></label>
                            <input type="url" id="fca-cm-space-cover-photo" class="fca-cm-form-control" placeholder="https://...">
                            <p class="fca-cm-field-hint"><?php _e('URL to the space cover/header image', 'fca-content-manager'); ?></p>
                        </div>

                        <!-- Type -->
                        <div class="fca-cm-form-group">
                            <label for="fca-cm-space-type"><?php _e('Type', 'fca-content-manager'); ?></label>
                            <input type="text" id="fca-cm-space-type" class="fca-cm-form-control" placeholder="Leave empty for default">
                            <p class="fca-cm-field-hint"><?php _e('Space type identifier (advanced)', 'fca-content-manager'); ?></p>
                        </div>

                        <!-- Parent ID & Serial Row -->
                        <div class="fca-cm-form-row">
                            <div class="fca-cm-form-group">
                                <label for="fca-cm-space-parent-id"><?php _e('Parent Space ID', 'fca-content-manager'); ?></label>
                                <input type="number" id="fca-cm-space-parent-id" class="fca-cm-form-control" placeholder="Optional">
                            </div>
                            
                            <div class="fca-cm-form-group">
                                <label for="fca-cm-space-serial"><?php _e('Serial/Order', 'fca-content-manager'); ?></label>
                                <input type="number" id="fca-cm-space-serial" class="fca-cm-form-control" placeholder="1">
                            </div>
                        </div>

                        <!-- Settings (JSON) -->
                        <div class="fca-cm-form-group">
                            <label for="fca-cm-space-settings"><?php _e('Settings (JSON)', 'fca-content-manager'); ?></label>
                            <textarea id="fca-cm-space-settings" class="fca-cm-form-control" rows="4" placeholder='{"key": "value"}'></textarea>
                            <p class="fca-cm-field-hint"><?php _e('Additional settings in JSON format (advanced)', 'fca-content-manager'); ?></p>
                        </div>

                        <!-- Status & Privacy Row -->
                        <div class="fca-cm-form-row">
                            <div class="fca-cm-form-group">
                                <label for="fca-cm-space-status-select"><?php _e('Status', 'fca-content-manager'); ?></label>
                                <select id="fca-cm-space-status-select" class="fca-cm-form-control">
                                    <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                                    <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                                    <option value="archived"><?php _e('Archived', 'fca-content-manager'); ?></option>
                                </select>
                            </div>
                            
                            <div class="fca-cm-form-group">
                                <label for="fca-cm-space-privacy-select"><?php _e('Privacy', 'fca-content-manager'); ?></label>
                                <select id="fca-cm-space-privacy-select" class="fca-cm-form-control">
                                    <option value="public"><?php _e('Public', 'fca-content-manager'); ?></option>
                                    <option value="private"><?php _e('Private', 'fca-content-manager'); ?></option>
                                </select>
                            </div>
                        </div>

                        <!-- Metadata -->
                        <div class="fca-cm-metadata-section">
                            <h3><?php _e('Metadata', 'fca-content-manager'); ?></h3>
                            
                            <div class="fca-cm-metadata-grid">
                                <div class="fca-cm-metadata-item">
                                    <label><?php _e('Created By', 'fca-content-manager'); ?></label>
                                    <span id="fca-cm-space-created-by">-</span>
                                </div>
                                <div class="fca-cm-metadata-item">
                                    <label><?php _e('Members Count', 'fca-content-manager'); ?></label>
                                    <span id="fca-cm-space-members-count">0</span>
                                </div>
                                <div class="fca-cm-metadata-item">
                                    <label><?php _e('Posts Count', 'fca-content-manager'); ?></label>
                                    <span id="fca-cm-space-posts-count">0</span>
                                </div>
                                <div class="fca-cm-metadata-item">
                                    <label><?php _e('Created', 'fca-content-manager'); ?></label>
                                    <span id="fca-cm-space-created">-</span>
                                </div>
                                <div class="fca-cm-metadata-item">
                                    <label><?php _e('Updated', 'fca-content-manager'); ?></label>
                                    <span id="fca-cm-space-updated">-</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bulk Edit Panel (Hidden by default) -->
<div id="fca-cm-space-bulk-edit-panel" class="fca-cm-bulk-edit-panel" style="display: none;">
    <div class="fca-cm-bulk-edit-header">
        <h3><?php _e('Bulk Edit Spaces', 'fca-content-manager'); ?></h3>
        <button type="button" class="fca-cm-btn fca-cm-btn-secondary" id="fca-cm-cancel-bulk-edit-spaces">
            <?php _e('Cancel', 'fca-content-manager'); ?>
        </button>
    </div>
    <div class="fca-cm-bulk-edit-body">
        <p class="fca-cm-help-text"><?php _e('Changes will apply to all selected spaces. Leave fields empty to keep current values.', 'fca-content-manager'); ?></p>
        
        <div class="fca-cm-form-row">
            <div class="fca-cm-form-group">
                <label for="fca-cm-bulk-space-status"><?php _e('Status', 'fca-content-manager'); ?></label>
                <select id="fca-cm-bulk-space-status" class="fca-cm-form-control">
                    <option value=""><?php _e('-- No Change --', 'fca-content-manager'); ?></option>
                    <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                    <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                    <option value="archived"><?php _e('Archived', 'fca-content-manager'); ?></option>
                </select>
            </div>
            
            <div class="fca-cm-form-group">
                <label for="fca-cm-bulk-space-privacy"><?php _e('Privacy', 'fca-content-manager'); ?></label>
                <select id="fca-cm-bulk-space-privacy" class="fca-cm-form-control">
                    <option value=""><?php _e('-- No Change --', 'fca-content-manager'); ?></option>
                    <option value="public"><?php _e('Public', 'fca-content-manager'); ?></option>
                    <option value="private"><?php _e('Private', 'fca-content-manager'); ?></option>
                </select>
            </div>
        </div>
        
        <button type="button" class="fca-cm-btn fca-cm-btn-primary" id="fca-cm-save-bulk-spaces">
            <span class="dashicons dashicons-saved"></span>
            <?php _e('Update Selected Spaces', 'fca-content-manager'); ?>
        </button>
    </div>
</div>