<?php
// Prevent direct access
defined('ABSPATH') or die('No direct script access allowed');
?>

<div class="fca-cm-wrap">
    <!-- Header -->
    <div class="fca-cm-header">
        <div class="fca-cm-header-content">
            <div>
                <h1 class="fca-cm-page-title">
                    <span class="dashicons dashicons-heart"></span>
                    <?php _e('Reactions Manager', 'fca-content-manager'); ?>
                </h1>
                <p class="fca-cm-page-description">
                    <?php _e('Manage all reactions to posts and comments', 'fca-content-manager'); ?>
                </p>
            </div>
            <div class="fca-cm-header-actions">
                <button type="button" class="fca-cm-btn fca-cm-btn-secondary" id="fca-cm-refresh-reactions">
                    <span class="dashicons dashicons-update"></span>
                    <?php _e('Refresh', 'fca-content-manager'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="fca-cm-content">
        <div class="fca-cm-single-panel">
            <!-- Filters -->
            <div class="fca-cm-filters">
                <div class="fca-cm-filter-row">
                    <select id="fca-cm-reactions-type" class="fca-cm-filter-select">
                        <option value=""><?php _e('All Reaction Types', 'fca-content-manager'); ?></option>
                        <option value="like">👍 <?php _e('Like', 'fca-content-manager'); ?></option>
                        <option value="love">❤️ <?php _e('Love', 'fca-content-manager'); ?></option>
                        <option value="laugh">😂 <?php _e('Laugh', 'fca-content-manager'); ?></option>
                        <option value="wow">😮 <?php _e('Wow', 'fca-content-manager'); ?></option>
                        <option value="sad">😢 <?php _e('Sad', 'fca-content-manager'); ?></option>
                        <option value="angry">😠 <?php _e('Angry', 'fca-content-manager'); ?></option>
                    </select>
                    
                    <select id="fca-cm-reactions-per-page" class="fca-cm-filter-select">
                        <option value="20">20 <?php _e('per page', 'fca-content-manager'); ?></option>
                        <option value="50">50 <?php _e('per page', 'fca-content-manager'); ?></option>
                        <option value="100">100 <?php _e('per page', 'fca-content-manager'); ?></option>
                    </select>
                </div>
            </div>

            <!-- Reactions Table -->
            <div class="fca-cm-table-container">
                <table class="fca-cm-table" id="fca-cm-reactions-table">
                    <thead>
                        <tr>
                            <th><?php _e('ID', 'fca-content-manager'); ?></th>
                            <th><?php _e('User', 'fca-content-manager'); ?></th>
                            <th><?php _e('Reaction', 'fca-content-manager'); ?></th>
                            <th><?php _e('Post ID', 'fca-content-manager'); ?></th>
                            <th><?php _e('Comment ID', 'fca-content-manager'); ?></th>
                            <th><?php _e('Date', 'fca-content-manager'); ?></th>
                            <th><?php _e('Actions', 'fca-content-manager'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="fca-cm-loading-row">
                            <td colspan="7">
                                <div class="fca-cm-loading">
                                    <span class="fca-cm-spinner"></span>
                                    <p><?php _e('Loading reactions...', 'fca-content-manager'); ?></p>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="fca-cm-pagination" id="fca-cm-reactions-pagination"></div>
        </div>
    </div>
</div>

