<?php
// Prevent direct access
defined('ABSPATH') or die('No direct script access allowed');

// Get spaces for filters
$spaces = FCA_CM_Database::get_spaces();
?>

<div class="fca-cm-wrap">
    <!-- Header -->
    <div class="fca-cm-header">
        <div class="fca-cm-header-content">
            <div>
                <h1 class="fca-cm-page-title">
                    <span class="dashicons dashicons-edit-large"></span>
                    <?php _e('Posts Manager', 'fca-content-manager'); ?>
                </h1>
                <p class="fca-cm-page-description">
                    <?php _e('Manage all community posts with advanced search and filtering', 'fca-content-manager'); ?>
                </p>
            </div>
            <div class="fca-cm-header-actions">
                <button type="button" class="fca-cm-btn fca-cm-btn-secondary" id="fca-cm-refresh">
                    <span class="dashicons dashicons-update"></span>
                    <?php _e('Refresh', 'fca-content-manager'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="fca-cm-content">
        <div class="fca-cm-split-view">
            <!-- Left Panel: Posts List -->
            <div class="fca-cm-list-panel">
                <!-- Filters and Search -->
                <div class="fca-cm-filters">
                    <div class="fca-cm-search-box">
                        <span class="dashicons dashicons-search"></span>
                        <input type="text" 
                               id="fca-cm-search" 
                               class="fca-cm-search-input" 
                               placeholder="<?php esc_attr_e('Search posts...', 'fca-content-manager'); ?>">
                    </div>
                    
                    <div class="fca-cm-filter-row">
                        <select id="fca-cm-filter-status" class="fca-cm-filter-select">
                            <option value=""><?php _e('All Statuses', 'fca-content-manager'); ?></option>
                            <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                            <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                            <option value="pending"><?php _e('Pending', 'fca-content-manager'); ?></option>
                            <option value="archived"><?php _e('Archived', 'fca-content-manager'); ?></option>
                        </select>
                        
                        <select id="fca-cm-filter-space" class="fca-cm-filter-select">
                            <option value=""><?php _e('All Spaces', 'fca-content-manager'); ?></option>
                            <?php foreach ($spaces as $space) : ?>
                                <option value="<?php echo esc_attr($space->id); ?>">
                                    <?php echo esc_html($space->title); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        
                        <select id="fca-cm-per-page" class="fca-cm-filter-select">
                            <option value="20">20 <?php _e('per page', 'fca-content-manager'); ?></option>
                            <option value="50">50 <?php _e('per page', 'fca-content-manager'); ?></option>
                            <option value="100">100 <?php _e('per page', 'fca-content-manager'); ?></option>
                        </select>
                    </div>
                    
                    <div class="fca-cm-bulk-actions">
                        <input type="checkbox" id="fca-cm-select-all" class="fca-cm-checkbox">
                        <label for="fca-cm-select-all"><?php _e('Select All', 'fca-content-manager'); ?></label>
                        <button type="button" class="fca-cm-btn fca-cm-btn-sm fca-cm-btn-primary" id="fca-cm-bulk-edit" disabled>
                            <span class="dashicons dashicons-edit"></span>
                            <?php _e('Bulk Edit', 'fca-content-manager'); ?>
                        </button>
                        <button type="button" class="fca-cm-btn fca-cm-btn-sm fca-cm-btn-danger" id="fca-cm-bulk-delete" disabled>
                            <span class="dashicons dashicons-trash"></span>
                            <?php _e('Delete', 'fca-content-manager'); ?>
                        </button>
                        <span class="fca-cm-selected-count"></span>
                    </div>
                </div>

                <!-- Posts List -->
                <div class="fca-cm-list-container" id="fca-cm-posts-list">
                    <div class="fca-cm-loading">
                        <span class="fca-cm-spinner"></span>
                        <p><?php _e('Loading posts...', 'fca-content-manager'); ?></p>
                    </div>
                </div>

                <!-- Pagination -->
                <div class="fca-cm-pagination" id="fca-cm-pagination"></div>
            </div>

            <!-- Right Panel: Post Details -->
            <div class="fca-cm-detail-panel" id="fca-cm-detail-panel">
                <div class="fca-cm-detail-empty">
                    <span class="dashicons dashicons-admin-post"></span>
                    <h3><?php _e('No Post Selected', 'fca-content-manager'); ?></h3>
                    <p><?php _e('Select a post from the list to view and edit details', 'fca-content-manager'); ?></p>
                </div>
                
                <div class="fca-cm-detail-content" style="display: none;">
                    <!-- Header -->
                    <div class="fca-cm-detail-header">
                        <button type="button" class="fca-cm-btn fca-cm-btn-icon" id="fca-cm-close-detail">
                            <span class="dashicons dashicons-no-alt"></span>
                        </button>
                        <h2><?php _e('Post Details', 'fca-content-manager'); ?></h2>
                        <div class="fca-cm-detail-actions">
                            <button type="button" class="fca-cm-btn fca-cm-btn-primary" id="fca-cm-save-post">
                                <span class="dashicons dashicons-yes"></span>
                                <?php _e('Save Changes', 'fca-content-manager'); ?>
                            </button>
                            <button type="button" class="fca-cm-btn fca-cm-btn-danger" id="fca-cm-delete-post">
                                <span class="dashicons dashicons-trash"></span>
                                <?php _e('Delete', 'fca-content-manager'); ?>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Scrollable Content -->
                    <div class="fca-cm-detail-body">
                        <form id="fca-cm-post-form">
                            <input type="hidden" id="fca-cm-post-id" name="post_id">
                            
                            <!-- Basic Info -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Basic Information', 'fca-content-manager'); ?></h3>
                                
                                <div class="fca-cm-form-group">
                                    <label for="fca-cm-post-title"><?php _e('Title', 'fca-content-manager'); ?></label>
                                    <input type="text" 
                                           id="fca-cm-post-title" 
                                           name="title" 
                                           class="fca-cm-form-control">
                                </div>
                                
                                <div class="fca-cm-form-group">
                                    <label for="fca-cm-post-message"><?php _e('Content', 'fca-content-manager'); ?></label>
                                    <textarea id="fca-cm-post-message" 
                                              name="message" 
                                              class="fca-cm-form-control" 
                                              rows="8"></textarea>
                                </div>
                            </div>
                            
                            <!-- Settings -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Settings', 'fca-content-manager'); ?></h3>
                                
                                <div class="fca-cm-form-row">
                                    <div class="fca-cm-form-group">
                                        <label for="fca-cm-post-status"><?php _e('Status', 'fca-content-manager'); ?></label>
                                        <select id="fca-cm-post-status" name="status" class="fca-cm-form-control">
                                            <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                                            <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                                            <option value="pending"><?php _e('Pending', 'fca-content-manager'); ?></option>
                                            <option value="archived"><?php _e('Archived', 'fca-content-manager'); ?></option>
                                        </select>
                                    </div>
                                    
                                    <div class="fca-cm-form-group">
                                        <label for="fca-cm-post-privacy"><?php _e('Privacy', 'fca-content-manager'); ?></label>
                                        <select id="fca-cm-post-privacy" name="privacy" class="fca-cm-form-control">
                                            <option value="public"><?php _e('Public', 'fca-content-manager'); ?></option>
                                            <option value="private"><?php _e('Private', 'fca-content-manager'); ?></option>
                                            <option value="space"><?php _e('Space Only', 'fca-content-manager'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="fca-cm-form-group">
                                    <label class="fca-cm-checkbox-label">
                                        <input type="checkbox" id="fca-cm-post-sticky" name="is_sticky" value="1">
                                        <?php _e('Make this post sticky', 'fca-content-manager'); ?>
                                    </label>
                                </div>
                            </div>
                            
                            <!-- Metadata -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Metadata', 'fca-content-manager'); ?></h3>
                                
                                <div class="fca-cm-form-row">
                                    <div class="fca-cm-form-group">
                                        <label for="fca-cm-post-space-select"><?php _e('Space', 'fca-content-manager'); ?></label>
                                        <select id="fca-cm-post-space-select" name="space_id" class="fca-cm-form-control">
                                            <option value=""><?php _e('No Space', 'fca-content-manager'); ?></option>
                                            <?php foreach ($spaces as $space) : ?>
                                                <option value="<?php echo esc_attr($space->id); ?>">
                                                    <?php echo esc_html($space->title); ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    
                                    <div class="fca-cm-form-group">
                                        <label for="fca-cm-post-author-id"><?php _e('Author ID', 'fca-content-manager'); ?></label>
                                        <input type="number" 
                                               id="fca-cm-post-author-id" 
                                               name="user_id" 
                                               class="fca-cm-form-control"
                                               placeholder="<?php esc_attr_e('User ID', 'fca-content-manager'); ?>">
                                        <small class="fca-cm-field-hint" id="fca-cm-post-author-name"></small>
                                    </div>
                                </div>
                                
                                <div class="fca-cm-form-row">
                                    <div class="fca-cm-form-group">
                                        <label for="fca-cm-post-created-date"><?php _e('Created Date', 'fca-content-manager'); ?></label>
                                        <input type="datetime-local" 
                                               id="fca-cm-post-created-date" 
                                               name="created_at" 
                                               class="fca-cm-form-control">
                                    </div>
                                    
                                    <div class="fca-cm-form-group">
                                        <label for="fca-cm-post-updated-date"><?php _e('Updated Date', 'fca-content-manager'); ?></label>
                                        <input type="datetime-local" 
                                               id="fca-cm-post-updated-date" 
                                               name="updated_at" 
                                               class="fca-cm-form-control">
                                    </div>
                                </div>
                                
                                <div class="fca-cm-meta-grid">
                                    <div class="fca-cm-meta-item">
                                        <span class="fca-cm-meta-label"><?php _e('Post ID:', 'fca-content-manager'); ?></span>
                                        <span class="fca-cm-meta-value" id="fca-cm-post-id-display"></span>
                                    </div>
                                    <div class="fca-cm-meta-item">
                                        <span class="fca-cm-meta-label"><?php _e('Type:', 'fca-content-manager'); ?></span>
                                        <span class="fca-cm-meta-value" id="fca-cm-post-type"></span>
                                    </div>
                                    <div class="fca-cm-meta-item">
                                        <span class="fca-cm-meta-label"><?php _e('Content Type:', 'fca-content-manager'); ?></span>
                                        <span class="fca-cm-meta-value" id="fca-cm-post-content-type"></span>
                                    </div>
                                    <div class="fca-cm-meta-item">
                                        <span class="fca-cm-meta-label"><?php _e('Comments:', 'fca-content-manager'); ?></span>
                                        <span class="fca-cm-meta-value" id="fca-cm-post-comments-count"></span>
                                    </div>
                                    <div class="fca-cm-meta-item">
                                        <span class="fca-cm-meta-label"><?php _e('Reactions:', 'fca-content-manager'); ?></span>
                                        <span class="fca-cm-meta-value" id="fca-cm-post-reactions-count"></span>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Topics/Terms -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Topics/Terms', 'fca-content-manager'); ?></h3>
                                <div id="fca-cm-post-terms" class="fca-cm-terms-list">
                                    <p class="fca-cm-empty-message"><?php _e('No topics assigned to this post', 'fca-content-manager'); ?></p>
                                </div>
                                <div class="fca-cm-form-group" style="margin-top: 12px;">
                                    <label><?php _e('Add Topic', 'fca-content-manager'); ?></label>
                                    <select id="fca-cm-add-term-select" class="fca-cm-form-control">
                                        <option value=""><?php _e('Select a topic...', 'fca-content-manager'); ?></option>
                                    </select>
                                </div>
                            </div>
                            
                            <!-- Media -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Attached Media', 'fca-content-manager'); ?></h3>
                                <div id="fca-cm-post-media" class="fca-cm-media-list">
                                    <p class="fca-cm-empty-message"><?php _e('No media attached to this post', 'fca-content-manager'); ?></p>
                                </div>
                            </div>
                            
                            <!-- Comments -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Comments', 'fca-content-manager'); ?></h3>
                                <div id="fca-cm-post-comments-list" class="fca-cm-comments-list">
                                    <p class="fca-cm-empty-message"><?php _e('No comments on this post', 'fca-content-manager'); ?></p>
                                </div>
                            </div>
                            
                            <!-- Reactions -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Reactions', 'fca-content-manager'); ?></h3>
                                <div id="fca-cm-post-reactions-list" class="fca-cm-reactions-list">
                                    <p class="fca-cm-empty-message"><?php _e('No reactions on this post', 'fca-content-manager'); ?></p>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Comment Modal -->
<div id="fca-cm-comment-modal" class="fca-cm-modal" style="display: none;">
    <div class="fca-cm-modal-overlay"></div>
    <div class="fca-cm-modal-content">
        <div class="fca-cm-modal-header">
            <h2><?php _e('Comment Details', 'fca-content-manager'); ?></h2>
            <button type="button" class="fca-cm-modal-close">
                <span class="dashicons dashicons-no-alt"></span>
            </button>
        </div>
        <div class="fca-cm-modal-body">
            <div class="fca-cm-comment-detail">
                <div class="fca-cm-comment-meta">
                    <strong id="fca-cm-modal-comment-author"></strong>
                    <span id="fca-cm-modal-comment-date"></span>
                </div>
                <div class="fca-cm-comment-content" id="fca-cm-modal-comment-content"></div>
                <div class="fca-cm-comment-info">
                    <span><?php _e('Status:', 'fca-content-manager'); ?> <strong id="fca-cm-modal-comment-status"></strong></span>
                    <span><?php _e('Reactions:', 'fca-content-manager'); ?> <strong id="fca-cm-modal-comment-reactions"></strong></span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bulk Edit Panel (will replace detail panel) -->
<div class="fca-cm-bulk-edit-panel" id="fca-cm-bulk-edit-panel" style="display: none;">
    <div class="fca-cm-detail-header">
        <button type="button" class="fca-cm-btn fca-cm-btn-icon" id="fca-cm-close-bulk-edit">
            <span class="dashicons dashicons-no-alt"></span>
        </button>
        <h2><?php _e('Bulk Edit', 'fca-content-manager'); ?> (<span id="fca-cm-bulk-count">0</span> <?php _e('posts selected', 'fca-content-manager'); ?>)</h2>
        <div class="fca-cm-detail-actions">
            <button type="button" class="fca-cm-btn fca-cm-btn-primary" id="fca-cm-save-bulk">
                <span class="dashicons dashicons-yes"></span>
                <?php _e('Apply Changes', 'fca-content-manager'); ?>
            </button>
        </div>
    </div>
    
    <div class="fca-cm-detail-body">
        <form id="fca-cm-bulk-form">
            <div class="fca-cm-form-section">
                <h3><?php _e('Bulk Update Settings', 'fca-content-manager'); ?></h3>
                <p class="fca-cm-help-text"><?php _e('Only fields with values will be updated. Leave blank to keep existing values.', 'fca-content-manager'); ?></p>
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-bulk-space"><?php _e('Change Space', 'fca-content-manager'); ?></label>
                    <select id="fca-cm-bulk-space" class="fca-cm-form-control">
                        <option value=""><?php _e('— No Change —', 'fca-content-manager'); ?></option>
                        <?php foreach ($spaces as $space) : ?>
                            <option value="<?php echo esc_attr($space->id); ?>">
                                <?php echo esc_html($space->title); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="fca-cm-form-row">
                    <div class="fca-cm-form-group">
                        <label for="fca-cm-bulk-status"><?php _e('Change Status', 'fca-content-manager'); ?></label>
                        <select id="fca-cm-bulk-status" class="fca-cm-form-control">
                            <option value=""><?php _e('— No Change —', 'fca-content-manager'); ?></option>
                            <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                            <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                            <option value="pending"><?php _e('Pending', 'fca-content-manager'); ?></option>
                            <option value="archived"><?php _e('Archived', 'fca-content-manager'); ?></option>
                        </select>
                    </div>
                    
                    <div class="fca-cm-form-group">
                        <label for="fca-cm-bulk-privacy"><?php _e('Change Privacy', 'fca-content-manager'); ?></label>
                        <select id="fca-cm-bulk-privacy" class="fca-cm-form-control">
                            <option value=""><?php _e('— No Change —', 'fca-content-manager'); ?></option>
                            <option value="public"><?php _e('Public', 'fca-content-manager'); ?></option>
                            <option value="private"><?php _e('Private', 'fca-content-manager'); ?></option>
                            <option value="space"><?php _e('Space Only', 'fca-content-manager'); ?></option>
                        </select>
                    </div>
                </div>
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-bulk-add-term"><?php _e('Add Topic to All', 'fca-content-manager'); ?></label>
                    <select id="fca-cm-bulk-add-term" class="fca-cm-form-control">
                        <option value=""><?php _e('Select a topic to add...', 'fca-content-manager'); ?></option>
                    </select>
                </div>
            </div>
        </form>
    </div>
</div>

