<?php
// Prevent direct access
defined('ABSPATH') or die('No direct script access allowed');
?>

<div class="fca-cm-wrap">
    <!-- Header -->
    <div class="fca-cm-header">
        <div class="fca-cm-header-content">
            <div>
                <h1 class="fca-cm-page-title">
                    <span class="dashicons dashicons-admin-settings"></span>
                    <?php _e('Metadata Manager', 'fca-content-manager'); ?>
                </h1>
                <p class="fca-cm-page-description">
                    <?php _e('Manage metadata for all content types', 'fca-content-manager'); ?>
                </p>
            </div>
            <div class="fca-cm-header-actions">
                <button type="button" class="fca-cm-btn fca-cm-btn-secondary" id="fca-cm-refresh-metadata">
                    <span class="dashicons dashicons-update"></span>
                    <?php _e('Refresh', 'fca-content-manager'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="fca-cm-content">
        <div class="fca-cm-single-panel">
            <!-- Filters -->
            <div class="fca-cm-filters">
                <div class="fca-cm-search-box">
                    <span class="dashicons dashicons-search"></span>
                    <input type="text" 
                           id="fca-cm-metadata-search" 
                           class="fca-cm-search-input" 
                           placeholder="<?php esc_attr_e('Search metadata key...', 'fca-content-manager'); ?>">
                </div>
                
                <div class="fca-cm-filter-row">
                    <select id="fca-cm-metadata-object-type" class="fca-cm-filter-select">
                        <option value=""><?php _e('All Object Types', 'fca-content-manager'); ?></option>
                        <option value="space"><?php _e('Space', 'fca-content-manager'); ?></option>
                        <option value="user"><?php _e('User', 'fca-content-manager'); ?></option>
                        <option value="xprofile"><?php _e('User Profile', 'fca-content-manager'); ?></option>
                        <option value="post"><?php _e('Post', 'fca-content-manager'); ?></option>
                        <option value="feed"><?php _e('Feed', 'fca-content-manager'); ?></option>
                        <option value="comment"><?php _e('Comment', 'fca-content-manager'); ?></option>
                        <option value="media"><?php _e('Media', 'fca-content-manager'); ?></option>
                        <option value="notification"><?php _e('Notification', 'fca-content-manager'); ?></option>
                        <option value="activity"><?php _e('Activity', 'fca-content-manager'); ?></option>
                        <option value="term"><?php _e('Term/Topic', 'fca-content-manager'); ?></option>
                        <option value="space_user"><?php _e('Space User', 'fca-content-manager'); ?></option>
                        <option value="course"><?php _e('Course', 'fca-content-manager'); ?></option>
                        <option value="course_section"><?php _e('Course Section', 'fca-content-manager'); ?></option>
                        <option value="course_lesson"><?php _e('Course Lesson', 'fca-content-manager'); ?></option>
                    </select>
                    
                    <select id="fca-cm-metadata-per-page" class="fca-cm-filter-select">
                        <option value="20">20 <?php _e('per page', 'fca-content-manager'); ?></option>
                        <option value="50">50 <?php _e('per page', 'fca-content-manager'); ?></option>
                        <option value="100">100 <?php _e('per page', 'fca-content-manager'); ?></option>
                    </select>
                </div>
            </div>

            <!-- Metadata Table -->
            <div class="fca-cm-table-container">
                <table class="fca-cm-table" id="fca-cm-metadata-table">
                    <thead>
                        <tr>
                            <th><?php _e('ID', 'fca-content-manager'); ?></th>
                            <th><?php _e('Object Type', 'fca-content-manager'); ?></th>
                            <th><?php _e('Object ID', 'fca-content-manager'); ?></th>
                            <th><?php _e('Meta Key', 'fca-content-manager'); ?></th>
                            <th><?php _e('Meta Value', 'fca-content-manager'); ?></th>
                            <th><?php _e('Created', 'fca-content-manager'); ?></th>
                            <th><?php _e('Actions', 'fca-content-manager'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="fca-cm-loading-row">
                            <td colspan="7">
                                <div class="fca-cm-loading">
                                    <span class="fca-cm-spinner"></span>
                                    <p><?php _e('Loading metadata...', 'fca-content-manager'); ?></p>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="fca-cm-pagination" id="fca-cm-metadata-pagination"></div>
        </div>
    </div>
</div>

<!-- Metadata Edit Modal -->
<div id="fca-cm-metadata-edit-modal" class="fca-cm-modal" style="display: none;">
    <div class="fca-cm-modal-overlay"></div>
    <div class="fca-cm-modal-content">
        <div class="fca-cm-modal-header">
            <h2><?php _e('Edit Metadata', 'fca-content-manager'); ?></h2>
            <button type="button" class="fca-cm-modal-close">
                <span class="dashicons dashicons-no-alt"></span>
            </button>
        </div>
        <div class="fca-cm-modal-body">
            <form id="fca-cm-metadata-edit-form">
                <input type="hidden" id="fca-cm-meta-id">
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-meta-object-type"><?php _e('Object Type', 'fca-content-manager'); ?></label>
                    <input type="text" id="fca-cm-meta-object-type" class="fca-cm-form-control" readonly>
                </div>
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-meta-object-id"><?php _e('Object ID', 'fca-content-manager'); ?></label>
                    <input type="text" id="fca-cm-meta-object-id" class="fca-cm-form-control" readonly>
                </div>
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-meta-key"><?php _e('Meta Key', 'fca-content-manager'); ?></label>
                    <input type="text" id="fca-cm-meta-key" class="fca-cm-form-control" readonly>
                </div>
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-meta-value"><?php _e('Meta Value', 'fca-content-manager'); ?></label>
                    <textarea id="fca-cm-meta-value" class="fca-cm-form-control" rows="10"></textarea>
                    <p class="fca-cm-help-text"><?php _e('Edit the metadata value. JSON values will be validated.', 'fca-content-manager'); ?></p>
                </div>
            </form>
        </div>
        <div class="fca-cm-modal-footer">
            <button type="button" class="fca-cm-btn fca-cm-btn-secondary fca-cm-modal-close">
                <?php _e('Cancel', 'fca-content-manager'); ?>
            </button>
            <button type="button" class="fca-cm-btn fca-cm-btn-primary" id="fca-cm-save-metadata">
                <span class="dashicons dashicons-saved"></span>
                <?php _e('Save Metadata', 'fca-content-manager'); ?>
            </button>
        </div>
    </div>
</div>

