<?php
/**
 * Members Management Page
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

$spaces = FCA_CM_Database::get_spaces();
?>

<div class="fca-cm-wrap">
    <!-- Header -->
    <div class="fca-cm-header">
        <div class="fca-cm-header-content">
            <div>
                <h1 class="fca-cm-page-title">
                    <span class="dashicons dashicons-admin-users"></span>
                    <?php _e('Members Manager', 'fca-content-manager'); ?>
                </h1>
                <p class="fca-cm-page-description">
                    <?php _e('Manage community members and their enrollments', 'fca-content-manager'); ?>
                </p>
            </div>
            <div class="fca-cm-header-actions">
                <button type="button" class="fca-cm-btn fca-cm-btn-secondary" id="fca-cm-refresh-members">
                    <span class="dashicons dashicons-update"></span>
                    <?php _e('Refresh', 'fca-content-manager'); ?>
                </button>
            </div>
        </div>
    </div>

    <div class="fca-cm-content">
        <div class="fca-cm-split-view">
        <div class="fca-cm-list-panel">
            <!-- Filters and Search -->
            <div class="fca-cm-filters">
                <div class="fca-cm-search-box">
                    <span class="dashicons dashicons-search"></span>
                    <input type="text" id="fca-cm-members-search" class="fca-cm-search-input" 
                           placeholder="<?php esc_attr_e('Search members...', 'fca-content-manager'); ?>">
                </div>
                
                <div class="fca-cm-filter-row">
                    <select id="fca-cm-member-status-filter" class="fca-cm-filter-select">
                        <option value=""><?php _e('All Status', 'fca-content-manager'); ?></option>
                        <option value="active"><?php _e('Active', 'fca-content-manager'); ?></option>
                        <option value="blocked"><?php _e('Blocked', 'fca-content-manager'); ?></option>
                        <option value="pending"><?php _e('Pending', 'fca-content-manager'); ?></option>
                    </select>

                    <select id="fca-cm-member-role-filter" class="fca-cm-filter-select">
                        <option value=""><?php _e('All Roles', 'fca-content-manager'); ?></option>
                        <option value="admin"><?php _e('Admin', 'fca-content-manager'); ?></option>
                        <option value="moderator"><?php _e('Moderator', 'fca-content-manager'); ?></option>
                        <option value="member"><?php _e('Member', 'fca-content-manager'); ?></option>
                        <option value="student"><?php _e('Student', 'fca-content-manager'); ?></option>
                    </select>

                    <select id="fca-cm-member-space-filter" class="fca-cm-filter-select">
                        <option value=""><?php _e('All Spaces', 'fca-content-manager'); ?></option>
                        <?php foreach ($spaces as $space) : ?>
                            <option value="<?php echo esc_attr($space->id); ?>">
                                <?php echo esc_html($space->title); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="fca-cm-bulk-actions">
                    <input type="checkbox" id="fca-cm-select-all-members" class="fca-cm-checkbox">
                    <label for="fca-cm-select-all-members"><?php _e('Select All', 'fca-content-manager'); ?></label>
                    <button type="button" class="fca-cm-btn fca-cm-btn-sm fca-cm-btn-primary" id="fca-cm-bulk-enroll-members" disabled>
                        <span class="dashicons dashicons-plus-alt"></span>
                        <?php _e('Enroll', 'fca-content-manager'); ?>
                    </button>
                    <button type="button" class="fca-cm-btn fca-cm-btn-sm fca-cm-btn-danger" id="fca-cm-bulk-unenroll-members" disabled>
                        <span class="dashicons dashicons-minus"></span>
                        <?php _e('Unenroll', 'fca-content-manager'); ?>
                    </button>
                    <span class="fca-cm-selected-count"></span>
                </div>
            </div>

            <!-- Members List -->
            <div class="fca-cm-list-container" id="fca-cm-members-list">
                <div class="fca-cm-loading">
                    <span class="fca-cm-spinner"></span>
                    <p><?php _e('Loading members...', 'fca-content-manager'); ?></p>
                </div>
            </div>

            <!-- Pagination -->
            <div class="fca-cm-pagination"></div>
        </div>

        <div class="fca-cm-detail-panel">
            <div class="fca-cm-detail-empty">
                <div class="fca-cm-empty-state">
                    <span class="dashicons dashicons-admin-users"></span>
                    <h3><?php _e('No Member Selected', 'fca-content-manager'); ?></h3>
                    <p><?php _e('Select a member from the list to view and edit their details.', 'fca-content-manager'); ?></p>
                </div>
            </div>
            <div id="fca-cm-member-detail" style="display: none;"></div>
        </div>
        </div>
    </div>
</div>

<!-- Bulk Enroll Modal -->
<div id="fca-cm-bulk-enroll-modal" class="fca-cm-modal" style="display: none;">
    <div class="fca-cm-modal-content">
        <div class="fca-cm-modal-header">
            <h2><?php _e('Enroll Selected Members', 'fca-content-manager'); ?></h2>
            <button type="button" class="fca-cm-modal-close">&times;</button>
        </div>
        <div class="fca-cm-modal-body">
            <div class="fca-cm-form-group">
                <label for="fca-cm-bulk-enroll-space"><?php _e('Space/Course', 'fca-content-manager'); ?></label>
                <select id="fca-cm-bulk-enroll-space" class="fca-cm-input">
                    <option value=""><?php _e('Select Space or Course', 'fca-content-manager'); ?></option>
                    <?php foreach ($spaces as $space) : ?>
                        <option value="<?php echo esc_attr($space->id); ?>">
                            <?php echo esc_html($space->title); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="fca-cm-form-group">
                <label for="fca-cm-bulk-enroll-role"><?php _e('Role', 'fca-content-manager'); ?></label>
                <select id="fca-cm-bulk-enroll-role" class="fca-cm-input">
                    <option value="member"><?php _e('Member', 'fca-content-manager'); ?></option>
                    <option value="student"><?php _e('Student', 'fca-content-manager'); ?></option>
                    <option value="moderator"><?php _e('Moderator', 'fca-content-manager'); ?></option>
                    <option value="admin"><?php _e('Admin', 'fca-content-manager'); ?></option>
                </select>
            </div>
        </div>
        <div class="fca-cm-modal-footer">
            <button type="button" class="button button-secondary fca-cm-modal-close">
                <?php _e('Cancel', 'fca-content-manager'); ?>
            </button>
            <button type="button" id="fca-cm-save-bulk-enroll" class="button button-primary">
                <?php _e('Enroll Members', 'fca-content-manager'); ?>
            </button>
        </div>
    </div>
</div>

<!-- Bulk Unenroll Modal -->
<div id="fca-cm-bulk-unenroll-modal" class="fca-cm-modal" style="display: none;">
    <div class="fca-cm-modal-content">
        <div class="fca-cm-modal-header">
            <h2><?php _e('Remove Enrollment', 'fca-content-manager'); ?></h2>
            <button type="button" class="fca-cm-modal-close">&times;</button>
        </div>
        <div class="fca-cm-modal-body">
            <div class="fca-cm-form-group">
                <label for="fca-cm-bulk-unenroll-space"><?php _e('Space/Course', 'fca-content-manager'); ?></label>
                <select id="fca-cm-bulk-unenroll-space" class="fca-cm-input">
                    <option value=""><?php _e('Select Space or Course', 'fca-content-manager'); ?></option>
                    <?php foreach ($spaces as $space) : ?>
                        <option value="<?php echo esc_attr($space->id); ?>">
                            <?php echo esc_html($space->title); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <p class="description">
                <?php _e('This will remove the selected members from the chosen space or course.', 'fca-content-manager'); ?>
            </p>
        </div>
        <div class="fca-cm-modal-footer">
            <button type="button" class="button button-secondary fca-cm-modal-close">
                <?php _e('Cancel', 'fca-content-manager'); ?>
            </button>
            <button type="button" id="fca-cm-save-bulk-unenroll" class="button button-primary">
                <?php _e('Remove Enrollment', 'fca-content-manager'); ?>
            </button>
        </div>
    </div>
</div>

<!-- Add Enrollment Modal -->
<div id="fca-cm-add-enrollment-modal" class="fca-cm-modal" style="display: none;">
    <div class="fca-cm-modal-content">
        <div class="fca-cm-modal-header">
            <h2><?php _e('Add Enrollment', 'fca-content-manager'); ?></h2>
            <button type="button" class="fca-cm-modal-close">&times;</button>
        </div>
        <div class="fca-cm-modal-body">
            <div class="fca-cm-form-group">
                <label for="fca-cm-add-enrollment-space"><?php _e('Space/Course', 'fca-content-manager'); ?></label>
                <select id="fca-cm-add-enrollment-space" class="fca-cm-input">
                    <option value=""><?php _e('Select Space or Course', 'fca-content-manager'); ?></option>
                    <?php foreach ($spaces as $space) : ?>
                        <option value="<?php echo esc_attr($space->id); ?>">
                            <?php echo esc_html($space->title); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="fca-cm-form-group">
                <label for="fca-cm-add-enrollment-role"><?php _e('Role', 'fca-content-manager'); ?></label>
                <select id="fca-cm-add-enrollment-role" class="fca-cm-input">
                    <option value="member"><?php _e('Member', 'fca-content-manager'); ?></option>
                    <option value="student"><?php _e('Student', 'fca-content-manager'); ?></option>
                    <option value="moderator"><?php _e('Moderator', 'fca-content-manager'); ?></option>
                    <option value="admin"><?php _e('Admin', 'fca-content-manager'); ?></option>
                </select>
            </div>
        </div>
        <div class="fca-cm-modal-footer">
            <button type="button" class="button button-secondary fca-cm-modal-close">
                <?php _e('Cancel', 'fca-content-manager'); ?>
            </button>
            <button type="button" id="fca-cm-save-add-enrollment" class="button button-primary">
                <?php _e('Add Enrollment', 'fca-content-manager'); ?>
            </button>
        </div>
    </div>
</div>

