<?php
// Prevent direct access
defined('ABSPATH') or die('No direct script access allowed');
?>

<div class="fca-cm-wrap">
    <!-- Header -->
    <div class="fca-cm-header">
        <div class="fca-cm-header-content">
            <div>
                <h1 class="fca-cm-page-title">
                    <span class="dashicons dashicons-format-gallery"></span>
                    <?php _e('Media Manager', 'fca-content-manager'); ?>
                </h1>
                <p class="fca-cm-page-description">
                    <?php _e('Manage all media files in the community', 'fca-content-manager'); ?>
                </p>
            </div>
            <div class="fca-cm-header-actions">
                <button type="button" class="fca-cm-btn fca-cm-btn-secondary" id="fca-cm-refresh-media">
                    <span class="dashicons dashicons-update"></span>
                    <?php _e('Refresh', 'fca-content-manager'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="fca-cm-content">
        <div class="fca-cm-split-view">
            <!-- Left Panel: Media List -->
            <div class="fca-cm-list-panel">
                <!-- Filters and Search -->
                <div class="fca-cm-filters">
                    <div class="fca-cm-search-box">
                        <span class="dashicons dashicons-search"></span>
                        <input type="text" 
                               id="fca-cm-media-search" 
                               class="fca-cm-search-input" 
                               placeholder="<?php esc_attr_e('Search media...', 'fca-content-manager'); ?>">
                    </div>
                    
                    <div class="fca-cm-filter-row">
                        <select id="fca-cm-media-type" class="fca-cm-filter-select">
                            <option value=""><?php _e('All Media Types', 'fca-content-manager'); ?></option>
                            <option value="image"><?php _e('Images', 'fca-content-manager'); ?></option>
                            <option value="video"><?php _e('Videos', 'fca-content-manager'); ?></option>
                            <option value="document"><?php _e('Documents', 'fca-content-manager'); ?></option>
                            <option value="audio"><?php _e('Audio', 'fca-content-manager'); ?></option>
                        </select>
                        
                        <select id="fca-cm-media-space" class="fca-cm-filter-select">
                            <option value=""><?php _e('All Spaces', 'fca-content-manager'); ?></option>
                            <?php
                            $spaces = FCA_CM_Database::get_spaces();
                            foreach ($spaces as $space) : ?>
                                <option value="<?php echo esc_attr($space->id); ?>">
                                    <?php echo esc_html($space->title); ?>
                                </option>
                            <?php endforeach;
                            ?>
                        </select>
                        
                        <select id="fca-cm-media-per-page" class="fca-cm-filter-select">
                            <option value="20">20 <?php _e('per page', 'fca-content-manager'); ?></option>
                            <option value="50">50 <?php _e('per page', 'fca-content-manager'); ?></option>
                            <option value="100">100 <?php _e('per page', 'fca-content-manager'); ?></option>
                        </select>
                    </div>
                </div>
                
                <!-- Bulk Actions -->
                <div class="fca-cm-bulk-actions">
                    <input type="checkbox" id="fca-cm-select-all-media" class="fca-cm-checkbox">
                    <label for="fca-cm-select-all-media"><?php _e('Select All', 'fca-content-manager'); ?></label>
                    <button type="button" class="fca-cm-btn fca-cm-btn-sm fca-cm-btn-danger" id="fca-cm-bulk-delete-media" disabled>
                        <span class="dashicons dashicons-trash"></span>
                        <?php _e('Delete', 'fca-content-manager'); ?>
                    </button>
                    <span class="fca-cm-selected-count"></span>
                </div>

                <!-- Media List -->
                <div class="fca-cm-list-container" id="fca-cm-media-list">
                    <div class="fca-cm-loading">
                        <span class="fca-cm-spinner"></span>
                        <p><?php _e('Loading media...', 'fca-content-manager'); ?></p>
                    </div>
                </div>

                <!-- Pagination -->
                <div class="fca-cm-pagination" id="fca-cm-media-pagination"></div>
            </div>

            <!-- Right Panel: Media Details -->
            <div class="fca-cm-detail-panel" id="fca-cm-media-detail">
                <div class="fca-cm-detail-empty">
                    <span class="dashicons dashicons-format-image"></span>
                    <h3><?php _e('No Media Selected', 'fca-content-manager'); ?></h3>
                    <p><?php _e('Select a media file from the list to view details', 'fca-content-manager'); ?></p>
                </div>
                
                <div class="fca-cm-detail-content" style="display: none;">
                    <!-- Header -->
                    <div class="fca-cm-detail-header">
                        <button type="button" class="fca-cm-btn fca-cm-btn-icon" id="fca-cm-close-media">
                            <span class="dashicons dashicons-no-alt"></span>
                        </button>
                        <h2><?php _e('Media Details', 'fca-content-manager'); ?></h2>
                        <div class="fca-cm-detail-actions">
                            <button type="button" class="fca-cm-btn fca-cm-btn-danger" id="fca-cm-delete-media">
                                <span class="dashicons dashicons-trash"></span>
                                <?php _e('Delete', 'fca-content-manager'); ?>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Scrollable Content -->
                    <div class="fca-cm-detail-body">
                        <!-- Media Preview -->
                        <div class="fca-cm-form-section">
                            <h3><?php _e('Preview', 'fca-content-manager'); ?></h3>
                            <div id="fca-cm-media-preview" class="fca-cm-media-preview"></div>
                        </div>
                        
                        <!-- Media Info -->
                        <div class="fca-cm-form-section">
                            <h3><?php _e('File Information', 'fca-content-manager'); ?></h3>
                            
                            <div class="fca-cm-form-group">
                                <label><?php _e('ID', 'fca-content-manager'); ?></label>
                                <span id="fca-cm-media-id" class="fca-cm-meta-value"></span>
                            </div>
                            
                            <div class="fca-cm-form-group">
                                <label><?php _e('File Name', 'fca-content-manager'); ?></label>
                                <span id="fca-cm-media-filename" class="fca-cm-meta-value"></span>
                            </div>
                            
                            <div class="fca-cm-form-group">
                                <label><?php _e('Type', 'fca-content-manager'); ?></label>
                                <span id="fca-cm-media-type-display" class="fca-cm-meta-value"></span>
                            </div>
                            
                            <div class="fca-cm-form-group">
                                <label><?php _e('File Size', 'fca-content-manager'); ?></label>
                                <span id="fca-cm-media-size" class="fca-cm-meta-value"></span>
                            </div>
                            
                            <div class="fca-cm-form-group">
                                <label><?php _e('URL', 'fca-content-manager'); ?></label>
                                <a href="#" id="fca-cm-media-url" class="fca-cm-meta-value" target="_blank"></a>
                            </div>
                            
                            <div class="fca-cm-form-group">
                                <label><?php _e('Uploaded By', 'fca-content-manager'); ?></label>
                                <span id="fca-cm-media-user" class="fca-cm-meta-value"></span>
                            </div>
                            
                            <div class="fca-cm-form-group">
                                <label><?php _e('Uploaded', 'fca-content-manager'); ?></label>
                                <span id="fca-cm-media-created" class="fca-cm-meta-value"></span>
                            </div>
                        </div>
                        
                        <!-- Used In -->
                        <div class="fca-cm-form-section">
                            <h3><?php _e('Used In', 'fca-content-manager'); ?></h3>
                            <div id="fca-cm-media-used-in">
                                <p class="fca-cm-empty-message"><?php _e('Loading...', 'fca-content-manager'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

