<?php
/**
 * Import Wizard View
 */

defined('ABSPATH') or die('No direct script access allowed');
?>

<div class="wrap fca-cm-wrap">
    <h1><?php _e('Import Content', 'fca-content-manager'); ?></h1>
    
    <div class="fca-cm-import-wizard">
        <!-- Step 1: Upload File -->
        <div class="fca-cm-wizard-step fca-cm-wizard-step-1 active">
            <div class="fca-cm-wizard-header">
                <h2><?php _e('Step 1: Upload Import File', 'fca-content-manager'); ?></h2>
                <p><?php _e('Upload a JSON or CSV file to import', 'fca-content-manager'); ?></p>
            </div>
            
            <div class="fca-cm-wizard-body">
                <div class="fca-cm-upload-area">
                    <input type="file" id="fca-cm-import-file" accept=".json,.csv" style="display:none;">
                    <div class="fca-cm-upload-dropzone" id="fca-cm-dropzone">
                        <span class="dashicons dashicons-upload"></span>
                        <h3><?php _e('Drop your file here or click to browse', 'fca-content-manager'); ?></h3>
                        <p><?php _e('Supported formats: JSON, CSV (Max 50MB)', 'fca-content-manager'); ?></p>
                        <button type="button" class="button button-primary" id="fca-cm-browse-btn">
                            <?php _e('Browse Files', 'fca-content-manager'); ?>
                        </button>
                    </div>
                    
                    <div class="fca-cm-upload-result" style="display:none;">
                        <div class="fca-cm-file-info">
                            <span class="dashicons dashicons-media-document"></span>
                            <div>
                                <strong id="fca-cm-file-name"></strong>
                                <span id="fca-cm-file-size"></span>
                            </div>
                            <button type="button" class="button fca-cm-remove-file">
                                <span class="dashicons dashicons-no"></span>
                            </button>
                        </div>
                    </div>
                </div>
                
                <div class="fca-cm-divider">
                    <span><?php _e('OR', 'fca-content-manager'); ?></span>
                </div>
                
                <div class="fca-cm-template-section">
                    <h3><?php _e('Download Sample Templates', 'fca-content-manager'); ?></h3>
                    <p><?php _e('Use these templates to prepare your import data', 'fca-content-manager'); ?></p>
                    
                    <div class="fca-cm-template-grid">
                        <a href="#" class="fca-cm-template-card" data-template="posts" data-format="csv">
                            <span class="dashicons dashicons-edit-large"></span>
                            <strong><?php _e('Posts Template (CSV)', 'fca-content-manager'); ?></strong>
                        </a>
                        <a href="#" class="fca-cm-template-card" data-template="posts" data-format="json">
                            <span class="dashicons dashicons-edit-large"></span>
                            <strong><?php _e('Posts Template (JSON)', 'fca-content-manager'); ?></strong>
                        </a>
                        <a href="#" class="fca-cm-template-card" data-template="spaces" data-format="csv">
                            <span class="dashicons dashicons-groups"></span>
                            <strong><?php _e('Spaces Template (CSV)', 'fca-content-manager'); ?></strong>
                        </a>
                        <a href="#" class="fca-cm-template-card" data-template="spaces" data-format="json">
                            <span class="dashicons dashicons-groups"></span>
                            <strong><?php _e('Spaces Template (JSON)', 'fca-content-manager'); ?></strong>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Step 2: Map Fields (CSV only) -->
        <div class="fca-cm-wizard-step fca-cm-wizard-step-2">
            <div class="fca-cm-wizard-header">
                <h2><?php _e('Step 2: Map Fields', 'fca-content-manager'); ?></h2>
                <p><?php _e('Map your CSV columns to database fields', 'fca-content-manager'); ?></p>
            </div>
            
            <div class="fca-cm-wizard-body">
                <div class="fca-cm-field-mapping-container">
                    <table class="fca-cm-field-mapping-table">
                        <thead>
                            <tr>
                                <th><?php _e('CSV Column', 'fca-content-manager'); ?></th>
                                <th><?php _e('Sample Data', 'fca-content-manager'); ?></th>
                                <th><?php _e('Maps To', 'fca-content-manager'); ?></th>
                            </tr>
                        </thead>
                        <tbody id="fca-cm-field-mapping-body">
                            <!-- Populated by JavaScript -->
                        </tbody>
                    </table>
                    
                    <div class="fca-cm-auto-map-notice">
                        <span class="dashicons dashicons-info"></span>
                        <p><?php _e('Fields have been auto-mapped based on column names. Please review and adjust if needed.', 'fca-content-manager'); ?></p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Step 3: Configure Import Options -->
        <div class="fca-cm-wizard-step fca-cm-wizard-step-3">
            <div class="fca-cm-wizard-header">
                <h2><?php _e('Step 3: Import Options', 'fca-content-manager'); ?></h2>
                <p><?php _e('Configure how the import should be handled', 'fca-content-manager'); ?></p>
            </div>
            
            <div class="fca-cm-wizard-body">
                <div class="fca-cm-import-preview">
                    <h3><?php _e('Import Preview', 'fca-content-manager'); ?></h3>
                    <div class="fca-cm-preview-stats">
                        <div class="fca-cm-stat-box">
                            <span class="fca-cm-stat-number" id="fca-cm-preview-total">0</span>
                            <span class="fca-cm-stat-label"><?php _e('Total Items', 'fca-content-manager'); ?></span>
                        </div>
                        <div class="fca-cm-stat-box">
                            <span class="fca-cm-stat-number" id="fca-cm-preview-content-type">-</span>
                            <span class="fca-cm-stat-label"><?php _e('Content Type', 'fca-content-manager'); ?></span>
                        </div>
                    </div>
                    
                    <div class="fca-cm-preview-sample">
                        <h4><?php _e('Sample Data (First 5 items)', 'fca-content-manager'); ?></h4>
                        <div id="fca-cm-preview-sample-data"></div>
                    </div>
                </div>
                
                <div class="fca-cm-import-options-form">
                    <h3><?php _e('Import Behavior', 'fca-content-manager'); ?></h3>
                    
                    <div class="fca-cm-radio-group">
                        <label>
                            <input type="radio" name="duplicate_handling" value="skip" checked>
                            <span class="fca-cm-radio-label">
                                <strong><?php _e('Skip Duplicates', 'fca-content-manager'); ?></strong>
                                <small><?php _e('Existing items will not be modified', 'fca-content-manager'); ?></small>
                            </span>
                        </label>
                        <label>
                            <input type="radio" name="duplicate_handling" value="update">
                            <span class="fca-cm-radio-label">
                                <strong><?php _e('Update Existing', 'fca-content-manager'); ?></strong>
                                <small><?php _e('Update items if they already exist (matched by slug)', 'fca-content-manager'); ?></small>
                            </span>
                        </label>
                        <label>
                            <input type="radio" name="duplicate_handling" value="create">
                            <span class="fca-cm-radio-label">
                                <strong><?php _e('Create New Copies', 'fca-content-manager'); ?></strong>
                                <small><?php _e('Always create new items, even if similar ones exist', 'fca-content-manager'); ?></small>
                            </span>
                        </label>
                    </div>
                    
                    <h3><?php _e('Additional Options', 'fca-content-manager'); ?></h3>
                    
                    <div class="fca-cm-checkbox-group">
                        <label>
                            <input type="checkbox" name="create_spaces" checked>
                            <?php _e('Create missing spaces automatically', 'fca-content-manager'); ?>
                        </label>
                        <label>
                            <input type="checkbox" name="create_terms" checked>
                            <?php _e('Create missing terms/topics automatically', 'fca-content-manager'); ?>
                        </label>
                        <label>
                            <input type="checkbox" name="dry_run">
                            <?php _e('Dry run (preview without importing)', 'fca-content-manager'); ?>
                        </label>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Step 4: Import Progress & Results -->
        <div class="fca-cm-wizard-step fca-cm-wizard-step-4">
            <div class="fca-cm-wizard-header">
                <h2><?php _e('Step 4: Import Progress', 'fca-content-manager'); ?></h2>
                <p><?php _e('Your content is being imported...', 'fca-content-manager'); ?></p>
            </div>
            
            <div class="fca-cm-wizard-body">
                <div class="fca-cm-import-progress" id="fca-cm-import-progress">
                    <div class="fca-cm-progress-bar">
                        <div class="fca-cm-progress-fill" style="width: 0%"></div>
                    </div>
                    <p class="fca-cm-progress-text">0%</p>
                </div>
                
                <div class="fca-cm-import-results" id="fca-cm-import-results" style="display:none;">
                    <div class="fca-cm-success-icon">
                        <span class="dashicons dashicons-yes-alt"></span>
                    </div>
                    <h3><?php _e('Import Complete!', 'fca-content-manager'); ?></h3>
                    
                    <div class="fca-cm-results-grid">
                        <div class="fca-cm-result-item">
                            <span class="fca-cm-result-number fca-cm-result-imported">0</span>
                            <span class="fca-cm-result-label"><?php _e('Imported', 'fca-content-manager'); ?></span>
                        </div>
                        <div class="fca-cm-result-item">
                            <span class="fca-cm-result-number fca-cm-result-updated">0</span>
                            <span class="fca-cm-result-label"><?php _e('Updated', 'fca-content-manager'); ?></span>
                        </div>
                        <div class="fca-cm-result-item">
                            <span class="fca-cm-result-number fca-cm-result-skipped">0</span>
                            <span class="fca-cm-result-label"><?php _e('Skipped', 'fca-content-manager'); ?></span>
                        </div>
                        <div class="fca-cm-result-item">
                            <span class="fca-cm-result-number fca-cm-result-errors">0</span>
                            <span class="fca-cm-result-label"><?php _e('Errors', 'fca-content-manager'); ?></span>
                        </div>
                    </div>
                    
                    <div class="fca-cm-errors-container" id="fca-cm-import-errors" style="display:none;">
                        <h4><?php _e('Import Errors', 'fca-content-manager'); ?></h4>
                        <ul id="fca-cm-error-list"></ul>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Wizard Navigation -->
        <div class="fca-cm-wizard-footer">
            <button type="button" class="button button-large fca-cm-wizard-prev" style="display:none;">
                <?php _e('Previous', 'fca-content-manager'); ?>
            </button>
            <button type="button" class="button button-primary button-large fca-cm-wizard-next" disabled>
                <?php _e('Next', 'fca-content-manager'); ?>
            </button>
            <button type="button" class="button button-primary button-large fca-cm-wizard-import" style="display:none;">
                <span class="dashicons dashicons-upload"></span>
                <?php _e('Start Import', 'fca-content-manager'); ?>
            </button>
            <button type="button" class="button button-large fca-cm-wizard-restart" style="display:none;">
                <?php _e('Start New Import', 'fca-content-manager'); ?>
            </button>
        </div>
    </div>
</div>
