<?php
/**
 * Export Wizard View
 */

defined('ABSPATH') or die('No direct script access allowed');
?>

<div class="wrap fca-cm-wrap">
    <h1><?php _e('Export Content', 'fca-content-manager'); ?></h1>
    
    <div class="fca-cm-export-wizard">
        <!-- Step 1: Select Content Type -->
        <div class="fca-cm-wizard-step fca-cm-wizard-step-1 active">
            <div class="fca-cm-wizard-header">
                <h2><?php _e('Step 1: Choose Content Type', 'fca-content-manager'); ?></h2>
                <p><?php _e('Select what type of content you want to export', 'fca-content-manager'); ?></p>
            </div>
            
            <div class="fca-cm-wizard-body">
                <div class="fca-cm-content-type-grid">
                    <div class="fca-cm-content-type-card" data-type="posts">
                        <span class="dashicons dashicons-edit-large"></span>
                        <h3><?php _e('Posts', 'fca-content-manager'); ?></h3>
                        <p><?php _e('Export community posts', 'fca-content-manager'); ?></p>
                    </div>
                    
                    <div class="fca-cm-content-type-card" data-type="spaces">
                        <span class="dashicons dashicons-groups"></span>
                        <h3><?php _e('Spaces', 'fca-content-manager'); ?></h3>
                        <p><?php _e('Export spaces/groups', 'fca-content-manager'); ?></p>
                    </div>
                    
                    <div class="fca-cm-content-type-card" data-type="comments">
                        <span class="dashicons dashicons-admin-comments"></span>
                        <h3><?php _e('Comments', 'fca-content-manager'); ?></h3>
                        <p><?php _e('Export comments', 'fca-content-manager'); ?></p>
                    </div>
                    
                    <div class="fca-cm-content-type-card" data-type="reactions">
                        <span class="dashicons dashicons-heart"></span>
                        <h3><?php _e('Reactions', 'fca-content-manager'); ?></h3>
                        <p><?php _e('Export reactions (likes, etc.)', 'fca-content-manager'); ?></p>
                    </div>
                    
                    <div class="fca-cm-content-type-card" data-type="term_feed">
                        <span class="dashicons dashicons-tag"></span>
                        <h3><?php _e('Term Relationships', 'fca-content-manager'); ?></h3>
                        <p><?php _e('Export post-topic associations', 'fca-content-manager'); ?></p>
                    </div>
                    
                    <div class="fca-cm-content-type-card" data-type="space_users">
                        <span class="dashicons dashicons-admin-users"></span>
                        <h3><?php _e('Space Memberships', 'fca-content-manager'); ?></h3>
                        <p><?php _e('Export user-space relationships', 'fca-content-manager'); ?></p>
                    </div>
                    
                    <div class="fca-cm-content-type-card disabled" data-type="courses">
                        <span class="dashicons dashicons-welcome-learn-more"></span>
                        <h3><?php _e('Courses', 'fca-content-manager'); ?></h3>
                        <p><?php _e('Coming in Phase 2', 'fca-content-manager'); ?></p>
                        <span class="fca-cm-badge">Soon</span>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Step 2: Choose Format & Options -->
        <div class="fca-cm-wizard-step fca-cm-wizard-step-2">
            <div class="fca-cm-wizard-header">
                <h2><?php _e('Step 2: Export Format & Options', 'fca-content-manager'); ?></h2>
                <p><?php _e('Choose the export format and configure options', 'fca-content-manager'); ?></p>
            </div>
            
            <div class="fca-cm-wizard-body">
                <div class="fca-cm-form-group">
                    <label><?php _e('Export Format', 'fca-content-manager'); ?></label>
                    <div class="fca-cm-radio-group">
                        <label>
                            <input type="radio" name="export_format" value="json" checked>
                            <span class="fca-cm-radio-label">
                                <strong>JSON</strong>
                                <small><?php _e('Complete data with relationships (recommended)', 'fca-content-manager'); ?></small>
                            </span>
                        </label>
                        <label>
                            <input type="radio" name="export_format" value="csv">
                            <span class="fca-cm-radio-label">
                                <strong>CSV</strong>
                                <small><?php _e('Spreadsheet format (basic fields only)', 'fca-content-manager'); ?></small>
                            </span>
                        </label>
                    </div>
                </div>
                
                <!-- Posts-specific options -->
                <div class="fca-cm-export-options" data-content-type="posts">
                    <h3><?php _e('Filter Options', 'fca-content-manager'); ?></h3>
                    
                    <div class="fca-cm-form-row">
                        <div class="fca-cm-form-group">
                            <label><?php _e('Space', 'fca-content-manager'); ?></label>
                            <select id="fca-cm-export-space">
                                <option value=""><?php _e('All Spaces', 'fca-content-manager'); ?></option>
                                <?php
                                $spaces = FCA_CM_Database::get_spaces();
                                foreach ($spaces as $space) {
                                    echo '<option value="' . esc_attr($space->id) . '">' . esc_html($space->title) . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                        
                        <div class="fca-cm-form-group">
                            <label><?php _e('Status', 'fca-content-manager'); ?></label>
                            <select id="fca-cm-export-status">
                                <option value=""><?php _e('All Statuses', 'fca-content-manager'); ?></option>
                                <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                                <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                                <option value="pending"><?php _e('Pending', 'fca-content-manager'); ?></option>
                            </select>
                        </div>
                    </div>
                    
                    <h3><?php _e('Include Related Data', 'fca-content-manager'); ?></h3>
                    <p class="description"><?php _e('These options are only available for JSON export', 'fca-content-manager'); ?></p>
                    
                    <div class="fca-cm-checkbox-group">
                        <label>
                            <input type="checkbox" name="include_comments" checked>
                            <?php _e('Include Comments', 'fca-content-manager'); ?>
                        </label>
                        <label>
                            <input type="checkbox" name="include_reactions" checked>
                            <?php _e('Include Reactions', 'fca-content-manager'); ?>
                        </label>
                        <label>
                            <input type="checkbox" name="include_media" checked>
                            <?php _e('Include Media References', 'fca-content-manager'); ?>
                        </label>
                        <label>
                            <input type="checkbox" name="include_terms" checked>
                            <?php _e('Include Topics/Terms', 'fca-content-manager'); ?>
                        </label>
                    </div>
                </div>
                
                <!-- Spaces-specific options -->
                <div class="fca-cm-export-options" data-content-type="spaces" style="display:none;">
                    <h3><?php _e('Filter Options', 'fca-content-manager'); ?></h3>
                    
                    <div class="fca-cm-form-row">
                        <div class="fca-cm-form-group">
                            <label><?php _e('Status', 'fca-content-manager'); ?></label>
                            <select id="fca-cm-export-spaces-status">
                                <option value=""><?php _e('All Statuses', 'fca-content-manager'); ?></option>
                                <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                                <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                            </select>
                        </div>
                        
                        <div class="fca-cm-form-group">
                            <label><?php _e('Privacy', 'fca-content-manager'); ?></label>
                            <select id="fca-cm-export-spaces-privacy">
                                <option value=""><?php _e('All Privacy Levels', 'fca-content-manager'); ?></option>
                                <option value="public"><?php _e('Public', 'fca-content-manager'); ?></option>
                                <option value="private"><?php _e('Private', 'fca-content-manager'); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <!-- Comments-specific options -->
                <div class="fca-cm-export-options" data-content-type="comments" style="display:none;">
                    <h3><?php _e('Filter Options', 'fca-content-manager'); ?></h3>
                    
                    <div class="fca-cm-form-group">
                        <label><?php _e('Space', 'fca-content-manager'); ?></label>
                        <select id="fca-cm-export-comments-space">
                            <option value=""><?php _e('All Spaces', 'fca-content-manager'); ?></option>
                            <?php
                            foreach ($spaces as $space) {
                                echo '<option value="' . esc_attr($space->id) . '">' . esc_html($space->title) . '</option>';
                            }
                            ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Step 3: Generate & Download -->
        <div class="fca-cm-wizard-step fca-cm-wizard-step-3">
            <div class="fca-cm-wizard-header">
                <h2><?php _e('Step 3: Generate Export', 'fca-content-manager'); ?></h2>
                <p><?php _e('Review your selection and generate the export file', 'fca-content-manager'); ?></p>
            </div>
            
            <div class="fca-cm-wizard-body">
                <div class="fca-cm-export-summary">
                    <div class="fca-cm-summary-item">
                        <strong><?php _e('Content Type:', 'fca-content-manager'); ?></strong>
                        <span id="fca-cm-summary-type">-</span>
                    </div>
                    <div class="fca-cm-summary-item">
                        <strong><?php _e('Format:', 'fca-content-manager'); ?></strong>
                        <span id="fca-cm-summary-format">-</span>
                    </div>
                    <div class="fca-cm-summary-item">
                        <strong><?php _e('Filters:', 'fca-content-manager'); ?></strong>
                        <span id="fca-cm-summary-filters">-</span>
                    </div>
                </div>
                
                <div class="fca-cm-export-progress" style="display:none;">
                    <div class="fca-cm-spinner"></div>
                    <p><?php _e('Generating export file...', 'fca-content-manager'); ?></p>
                </div>
                
                <div class="fca-cm-export-result" style="display:none;">
                    <div class="fca-cm-success-icon">
                        <span class="dashicons dashicons-yes-alt"></span>
                    </div>
                    <h3><?php _e('Export Complete!', 'fca-content-manager'); ?></h3>
                    <p id="fca-cm-export-message"></p>
                    <a href="#" id="fca-cm-download-link" class="button button-primary button-large" download>
                        <span class="dashicons dashicons-download"></span>
                        <?php _e('Download Export File', 'fca-content-manager'); ?>
                    </a>
                </div>
                
                <div class="fca-cm-export-error" style="display:none;">
                    <div class="fca-cm-error-icon">
                        <span class="dashicons dashicons-warning"></span>
                    </div>
                    <h3><?php _e('Export Failed', 'fca-content-manager'); ?></h3>
                    <p id="fca-cm-export-error-message"></p>
                </div>
            </div>
        </div>
        
        <!-- Wizard Navigation -->
        <div class="fca-cm-wizard-footer">
            <button type="button" class="button button-large fca-cm-wizard-prev" style="display:none;">
                <?php _e('Previous', 'fca-content-manager'); ?>
            </button>
            <button type="button" class="button button-primary button-large fca-cm-wizard-next">
                <?php _e('Next', 'fca-content-manager'); ?>
            </button>
            <button type="button" class="button button-primary button-large fca-cm-wizard-export" style="display:none;">
                <span class="dashicons dashicons-download"></span>
                <?php _e('Generate Export', 'fca-content-manager'); ?>
            </button>
            <button type="button" class="button button-large fca-cm-wizard-restart" style="display:none;">
                <?php _e('Start New Export', 'fca-content-manager'); ?>
            </button>
        </div>
    </div>
</div>
