<?php
// Prevent direct access
defined('ABSPATH') or die('No direct script access allowed');

// Get spaces for filters
$spaces = FCA_CM_Database::get_spaces();
?>

<div class="fca-cm-wrap">
    <!-- Header -->
    <div class="fca-cm-header">
        <div class="fca-cm-header-content">
            <div>
                <h1 class="fca-cm-page-title">
                    <span class="dashicons dashicons-book-alt"></span>
                    <?php _e('Courses Manager', 'fca-content-manager'); ?>
                </h1>
                <p class="fca-cm-page-description">
                    <?php _e('Manage courses, sections, and lessons', 'fca-content-manager'); ?>
                </p>
            </div>
            <div class="fca-cm-header-actions">
                <button type="button" class="fca-cm-btn fca-cm-btn-secondary" id="fca-cm-refresh-courses">
                    <span class="dashicons dashicons-update"></span>
                    <?php _e('Refresh', 'fca-content-manager'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="fca-cm-content">
        <div class="fca-cm-split-view">
            <!-- Left Panel: Courses List -->
            <div class="fca-cm-list-panel">
                <!-- Filters and Search -->
                <div class="fca-cm-filters">
                    <div class="fca-cm-search-box">
                        <span class="dashicons dashicons-search"></span>
                        <input type="text" 
                               id="fca-cm-course-search" 
                               class="fca-cm-search-input" 
                               placeholder="<?php esc_attr_e('Search courses...', 'fca-content-manager'); ?>">
                    </div>
                    
                    <div class="fca-cm-filter-row">
                        <select id="fca-cm-course-status" class="fca-cm-filter-select">
                            <option value=""><?php _e('All Statuses', 'fca-content-manager'); ?></option>
                            <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                            <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                            <option value="archived"><?php _e('Archived', 'fca-content-manager'); ?></option>
                        </select>
                    </div>
                </div>
                
                <!-- Bulk Actions -->
                <div class="fca-cm-bulk-actions">
                    <input type="checkbox" id="fca-cm-select-all-courses" class="fca-cm-checkbox">
                    <label for="fca-cm-select-all-courses"><?php _e('Select All', 'fca-content-manager'); ?></label>
                    <button type="button" class="fca-cm-btn fca-cm-btn-sm fca-cm-btn-primary" id="fca-cm-bulk-edit-courses" disabled>
                        <span class="dashicons dashicons-edit"></span>
                        <?php _e('Bulk Edit', 'fca-content-manager'); ?>
                    </button>
                    <button type="button" class="fca-cm-btn fca-cm-btn-sm fca-cm-btn-danger" id="fca-cm-bulk-delete-courses" disabled>
                        <span class="dashicons dashicons-trash"></span>
                        <?php _e('Delete', 'fca-content-manager'); ?>
                    </button>
                    <span class="fca-cm-selected-count"></span>
                </div>

                <!-- Courses List -->
                <div class="fca-cm-list-container" id="fca-cm-courses-list">
                    <div class="fca-cm-loading">
                        <span class="fca-cm-spinner"></span>
                        <p><?php _e('Loading courses...', 'fca-content-manager'); ?></p>
                    </div>
                </div>

                <!-- Pagination -->
                <div class="fca-cm-pagination" id="fca-cm-course-pagination"></div>
            </div>

            <!-- Right Panel: Course Structure -->
            <div class="fca-cm-detail-panel" id="fca-cm-course-detail">
                <div class="fca-cm-detail-empty">
                    <span class="dashicons dashicons-book-alt"></span>
                    <h3><?php _e('No Course Selected', 'fca-content-manager'); ?></h3>
                    <p><?php _e('Select a course from the list to view its structure', 'fca-content-manager'); ?></p>
                </div>
                
                <div class="fca-cm-detail-content" style="display: none;">
                    <!-- Header -->
                    <div class="fca-cm-detail-header">
                        <button type="button" class="fca-cm-btn fca-cm-btn-icon" id="fca-cm-close-course-detail">
                            <span class="dashicons dashicons-no-alt"></span>
                        </button>
                        <h2 id="fca-cm-course-title"><?php _e('Course Structure', 'fca-content-manager'); ?></h2>
                        <div class="fca-cm-detail-actions">
                            <button type="button" class="fca-cm-btn fca-cm-btn-secondary" id="fca-cm-edit-course-details">
                                <span class="dashicons dashicons-edit"></span>
                                <?php _e('Edit Course Details', 'fca-content-manager'); ?>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Scrollable Content -->
                    <div class="fca-cm-detail-body">
                        
                        <!-- Course Structure Skeleton -->
                        <div class="fca-cm-course-structure">
                            <h3><?php _e('Course Structure', 'fca-content-manager'); ?></h3>
                            <div id="fca-cm-structure-tree" class="fca-cm-structure-tree">
                                <!-- Structure will be loaded here -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Course Edit Modal -->
<div id="fca-cm-course-details-modal" class="fca-cm-modal" style="display: none;">
    <div class="fca-cm-modal-overlay"></div>
    <div class="fca-cm-modal-content">
        <div class="fca-cm-modal-header">
            <h2><?php _e('Edit Course Details', 'fca-content-manager'); ?></h2>
            <button type="button" class="fca-cm-modal-close">
                <span class="dashicons dashicons-no-alt"></span>
            </button>
        </div>
        <div class="fca-cm-modal-body">
            <form id="fca-cm-course-details-form">
                <input type="hidden" id="fca-cm-course-id">
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-course-title-input"><?php _e('Course Title', 'fca-content-manager'); ?></label>
                    <input type="text" id="fca-cm-course-title-input" class="fca-cm-form-control">
                </div>
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-course-description"><?php _e('Description', 'fca-content-manager'); ?></label>
                    <textarea id="fca-cm-course-description" class="fca-cm-form-control" rows="5"></textarea>
                </div>
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-course-slug"><?php _e('Slug', 'fca-content-manager'); ?></label>
                    <input type="text" id="fca-cm-course-slug" class="fca-cm-form-control">
                </div>
                
                <div class="fca-cm-form-row">
                    <div class="fca-cm-form-group">
                        <label for="fca-cm-course-status-select"><?php _e('Status', 'fca-content-manager'); ?></label>
                        <select id="fca-cm-course-status-select" class="fca-cm-form-control">
                            <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                            <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                            <option value="archived"><?php _e('Archived', 'fca-content-manager'); ?></option>
                        </select>
                    </div>
                    
                    <div class="fca-cm-form-group">
                        <label for="fca-cm-course-privacy"><?php _e('Privacy', 'fca-content-manager'); ?></label>
                        <select id="fca-cm-course-privacy" class="fca-cm-form-control">
                            <option value="public"><?php _e('Public', 'fca-content-manager'); ?></option>
                            <option value="private"><?php _e('Private', 'fca-content-manager'); ?></option>
                        </select>
                    </div>
                </div>
                
                <div class="fca-cm-form-group">
                    <label><?php _e('Created', 'fca-content-manager'); ?></label>
                    <input type="text" id="fca-cm-course-created" class="fca-cm-form-control" readonly>
                </div>
                
                <div class="fca-cm-form-group">
                    <label><?php _e('Updated', 'fca-content-manager'); ?></label>
                    <input type="text" id="fca-cm-course-updated" class="fca-cm-form-control" readonly>
                </div>
            </form>
        </div>
        <div class="fca-cm-modal-footer">
            <button type="button" class="fca-cm-btn fca-cm-btn-secondary fca-cm-modal-close">
                <?php _e('Cancel', 'fca-content-manager'); ?>
            </button>
            <button type="button" class="fca-cm-btn fca-cm-btn-primary" id="fca-cm-save-course-details">
                <span class="dashicons dashicons-saved"></span>
                <?php _e('Save Course', 'fca-content-manager'); ?>
            </button>
        </div>
    </div>
</div>

<!-- Lesson Edit Modal -->
<div id="fca-cm-lesson-modal" class="fca-cm-modal" style="display: none;">
    <div class="fca-cm-modal-backdrop"></div>
    <div class="fca-cm-modal-content">
        <div class="fca-cm-modal-header">
            <h2><?php _e('Edit Lesson', 'fca-content-manager'); ?></h2>
            <button type="button" class="fca-cm-modal-close" data-close="lesson-modal">
                <span class="dashicons dashicons-no-alt"></span>
            </button>
        </div>
        <div class="fca-cm-modal-body">
            <form id="fca-cm-lesson-edit-form">
                <input type="hidden" id="fca-cm-lesson-edit-id" name="post_id">
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-lesson-edit-title"><?php _e('Lesson Title', 'fca-content-manager'); ?></label>
                    <input type="text" id="fca-cm-lesson-edit-title" name="title" class="fca-cm-form-control">
                </div>
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-lesson-edit-message"><?php _e('Content', 'fca-content-manager'); ?></label>
                    <textarea id="fca-cm-lesson-edit-message" name="message" class="fca-cm-form-control" rows="8"></textarea>
                </div>
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-lesson-edit-status"><?php _e('Status', 'fca-content-manager'); ?></label>
                    <select id="fca-cm-lesson-edit-status" name="status" class="fca-cm-form-control">
                        <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                        <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                    </select>
                </div>
            </form>
        </div>
        <div class="fca-cm-modal-footer">
            <button type="button" class="fca-cm-btn fca-cm-btn-secondary" data-close="lesson-modal">
                <?php _e('Cancel', 'fca-content-manager'); ?>
            </button>
            <button type="button" class="fca-cm-btn fca-cm-btn-primary" id="fca-cm-save-lesson-edit">
                <span class="dashicons dashicons-yes"></span>
                <?php _e('Save Changes', 'fca-content-manager'); ?>
            </button>
        </div>
    </div>
</div>

<!-- Move Item Modal -->
<div id="fca-cm-move-item-modal" class="fca-cm-modal" style="display: none;">
    <div class="fca-cm-modal-overlay"></div>
    <div class="fca-cm-modal-content">
        <div class="fca-cm-modal-header">
            <h2><?php _e('Move to Course', 'fca-content-manager'); ?></h2>
            <button type="button" class="fca-cm-modal-close">
                <span class="dashicons dashicons-no-alt"></span>
            </button>
        </div>
        <div class="fca-cm-modal-body">
            <p class="fca-cm-help-text" id="fca-cm-move-item-description"></p>
            <div class="fca-cm-form-group">
                <label for="fca-cm-move-target-course"><?php _e('Select Target Course', 'fca-content-manager'); ?></label>
                <select id="fca-cm-move-target-course" class="fca-cm-form-control">
                    <option value=""><?php _e('Select a course...', 'fca-content-manager'); ?></option>
                </select>
            </div>
            <div class="fca-cm-form-group" id="fca-cm-move-section-container" style="display: none;">
                <label for="fca-cm-move-target-section"><?php _e('Select Target Section (optional for lessons)', 'fca-content-manager'); ?></label>
                <select id="fca-cm-move-target-section" class="fca-cm-form-control">
                    <option value=""><?php _e('No section (make orphan)', 'fca-content-manager'); ?></option>
                </select>
            </div>
        </div>
        <div class="fca-cm-modal-footer">
            <button type="button" class="fca-cm-btn fca-cm-btn-secondary fca-cm-modal-close">
                <?php _e('Cancel', 'fca-content-manager'); ?>
            </button>
            <button type="button" class="fca-cm-btn fca-cm-btn-primary" id="fca-cm-confirm-move">
                <?php _e('Move', 'fca-content-manager'); ?>
            </button>
        </div>
    </div>
</div>

<!-- Course Bulk Edit Modal -->
<div id="fca-cm-course-bulk-edit-modal" class="fca-cm-modal" style="display: none;">
    <div class="fca-cm-modal-overlay"></div>
    <div class="fca-cm-modal-content">
        <div class="fca-cm-modal-header">
            <h2><?php _e('Bulk Edit Courses', 'fca-content-manager'); ?></h2>
            <button type="button" class="fca-cm-modal-close">
                <span class="dashicons dashicons-no-alt"></span>
            </button>
        </div>
        <div class="fca-cm-modal-body">
            <p class="fca-cm-help-text" id="fca-cm-bulk-edit-description">
                <?php _e('Update multiple courses at once. Only fill in the fields you want to change.', 'fca-content-manager'); ?>
            </p>
            <form id="fca-cm-course-bulk-edit-form">
                <div class="fca-cm-form-group">
                    <label for="fca-cm-bulk-course-status"><?php _e('Status', 'fca-content-manager'); ?></label>
                    <select id="fca-cm-bulk-course-status" class="fca-cm-form-control">
                        <option value=""><?php _e('-- No Change --', 'fca-content-manager'); ?></option>
                        <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                        <option value="draft"><?php _e('Draft', 'fca-content-manager'); ?></option>
                        <option value="archived"><?php _e('Archived', 'fca-content-manager'); ?></option>
                    </select>
                </div>
                
                <div class="fca-cm-form-group">
                    <label for="fca-cm-bulk-course-privacy"><?php _e('Privacy', 'fca-content-manager'); ?></label>
                    <select id="fca-cm-bulk-course-privacy" class="fca-cm-form-control">
                        <option value=""><?php _e('-- No Change --', 'fca-content-manager'); ?></option>
                        <option value="public"><?php _e('Public', 'fca-content-manager'); ?></option>
                        <option value="private"><?php _e('Private', 'fca-content-manager'); ?></option>
                    </select>
                </div>
            </form>
        </div>
        <div class="fca-cm-modal-footer">
            <button type="button" class="fca-cm-btn fca-cm-btn-secondary fca-cm-modal-close">
                <?php _e('Cancel', 'fca-content-manager'); ?>
            </button>
            <button type="button" class="fca-cm-btn fca-cm-btn-primary" id="fca-cm-save-bulk-courses">
                <span class="dashicons dashicons-saved"></span>
                <?php _e('Update Courses', 'fca-content-manager'); ?>
            </button>
        </div>
    </div>
</div>

