<?php
// Prevent direct access
defined('ABSPATH') or die('No direct script access allowed');
?>

<div class="fca-cm-wrap">
    <!-- Header -->
    <div class="fca-cm-header">
        <div class="fca-cm-header-content">
            <div>
                <h1 class="fca-cm-page-title">
                    <span class="dashicons dashicons-admin-comments"></span>
                    <?php _e('Comments Manager', 'fca-content-manager'); ?>
                </h1>
                <p class="fca-cm-page-description">
                    <?php _e('Manage all community comments', 'fca-content-manager'); ?>
                </p>
            </div>
            <div class="fca-cm-header-actions">
                <button type="button" class="fca-cm-btn fca-cm-btn-secondary" id="fca-cm-refresh-comments">
                    <span class="dashicons dashicons-update"></span>
                    <?php _e('Refresh', 'fca-content-manager'); ?>
                </button>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="fca-cm-content">
        <div class="fca-cm-split-view">
            <!-- Left Panel: Comments List -->
            <div class="fca-cm-list-panel">
                <!-- Filters and Search -->
                <div class="fca-cm-filters">
                    <div class="fca-cm-search-box">
                        <span class="dashicons dashicons-search"></span>
                        <input type="text" 
                               id="fca-cm-comments-search" 
                               class="fca-cm-search-input" 
                               placeholder="<?php esc_attr_e('Search comments...', 'fca-content-manager'); ?>">
                    </div>
                    
                    <div class="fca-cm-filter-row">
                        <select id="fca-cm-comments-status" class="fca-cm-filter-select">
                            <option value=""><?php _e('All Statuses', 'fca-content-manager'); ?></option>
                            <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                            <option value="pending"><?php _e('Pending', 'fca-content-manager'); ?></option>
                            <option value="spam"><?php _e('Spam', 'fca-content-manager'); ?></option>
                        </select>
                        
                        <select id="fca-cm-comments-space" class="fca-cm-filter-select">
                            <option value=""><?php _e('All Spaces', 'fca-content-manager'); ?></option>
                            <?php
                            $spaces = FCA_CM_Database::get_spaces();
                            foreach ($spaces as $space) : ?>
                                <option value="<?php echo esc_attr($space->id); ?>">
                                    <?php echo esc_html($space->title); ?>
                                </option>
                            <?php endforeach;
                            ?>
                        </select>
                        
                        <select id="fca-cm-comments-per-page" class="fca-cm-filter-select">
                            <option value="20">20 <?php _e('per page', 'fca-content-manager'); ?></option>
                            <option value="50">50 <?php _e('per page', 'fca-content-manager'); ?></option>
                            <option value="100">100 <?php _e('per page', 'fca-content-manager'); ?></option>
                        </select>
                    </div>
                </div>
                
                <!-- Bulk Actions -->
                <div class="fca-cm-bulk-actions">
                    <input type="checkbox" id="fca-cm-select-all-comments" class="fca-cm-checkbox">
                    <label for="fca-cm-select-all-comments"><?php _e('Select All', 'fca-content-manager'); ?></label>
                    <button type="button" class="fca-cm-btn fca-cm-btn-sm fca-cm-btn-primary" id="fca-cm-bulk-edit-comments" disabled>
                        <span class="dashicons dashicons-edit"></span>
                        <?php _e('Bulk Edit', 'fca-content-manager'); ?>
                    </button>
                    <button type="button" class="fca-cm-btn fca-cm-btn-sm fca-cm-btn-danger" id="fca-cm-bulk-delete-comments" disabled>
                        <span class="dashicons dashicons-trash"></span>
                        <?php _e('Delete', 'fca-content-manager'); ?>
                    </button>
                    <span class="fca-cm-selected-count"></span>
                </div>

                <!-- Comments List -->
                <div class="fca-cm-list-container" id="fca-cm-comments-list">
                    <div class="fca-cm-loading">
                        <span class="fca-cm-spinner"></span>
                        <p><?php _e('Loading comments...', 'fca-content-manager'); ?></p>
                    </div>
                </div>

                <!-- Pagination -->
                <div class="fca-cm-pagination" id="fca-cm-comments-pagination"></div>
            </div>

            <!-- Right Panel: Comment Details -->
            <div class="fca-cm-detail-panel" id="fca-cm-comment-detail">
                <div class="fca-cm-detail-empty">
                    <span class="dashicons dashicons-admin-comments"></span>
                    <h3><?php _e('No Comment Selected', 'fca-content-manager'); ?></h3>
                    <p><?php _e('Select a comment from the list to view details', 'fca-content-manager'); ?></p>
                </div>
                
                <div class="fca-cm-detail-content" style="display: none;">
                    <!-- Header -->
                    <div class="fca-cm-detail-header">
                        <button type="button" class="fca-cm-btn fca-cm-btn-icon" id="fca-cm-close-comment">
                            <span class="dashicons dashicons-no-alt"></span>
                        </button>
                        <h2><?php _e('Comment Details', 'fca-content-manager'); ?></h2>
                        <div class="fca-cm-detail-actions">
                            <button type="button" class="fca-cm-btn fca-cm-btn-primary" id="fca-cm-save-comment">
                                <span class="dashicons dashicons-saved"></span>
                                <?php _e('Save Changes', 'fca-content-manager'); ?>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Scrollable Content -->
                    <div class="fca-cm-detail-body">
                        <form id="fca-cm-comment-form">
                            <input type="hidden" id="fca-cm-comment-id">
                            
                            <!-- Comment Content -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Comment Content', 'fca-content-manager'); ?></h3>
                                
                                <div class="fca-cm-form-group">
                                    <label for="fca-cm-comment-message"><?php _e('Message', 'fca-content-manager'); ?></label>
                                    <textarea id="fca-cm-comment-message" class="fca-cm-form-control" rows="6"></textarea>
                                </div>
                                
                                <div class="fca-cm-form-row">
                                    <div class="fca-cm-form-group">
                                        <label for="fca-cm-comment-status"><?php _e('Status', 'fca-content-manager'); ?></label>
                                        <select id="fca-cm-comment-status" class="fca-cm-form-control">
                                            <option value="published"><?php _e('Published', 'fca-content-manager'); ?></option>
                                            <option value="pending"><?php _e('Pending', 'fca-content-manager'); ?></option>
                                            <option value="spam"><?php _e('Spam', 'fca-content-manager'); ?></option>
                                        </select>
                                    </div>
                                    
                                    <div class="fca-cm-form-group">
                                        <label for="fca-cm-comment-privacy"><?php _e('Privacy', 'fca-content-manager'); ?></label>
                                        <select id="fca-cm-comment-privacy" class="fca-cm-form-control">
                                            <option value="public"><?php _e('Public', 'fca-content-manager'); ?></option>
                                            <option value="private"><?php _e('Private', 'fca-content-manager'); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Metadata -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Metadata', 'fca-content-manager'); ?></h3>
                                
                                <div class="fca-cm-form-group">
                                    <label><?php _e('ID', 'fca-content-manager'); ?></label>
                                    <span id="fca-cm-comment-id-display" class="fca-cm-meta-value"></span>
                                </div>
                                
                                <div class="fca-cm-form-group">
                                    <label><?php _e('Author', 'fca-content-manager'); ?></label>
                                    <span id="fca-cm-comment-author" class="fca-cm-meta-value"></span>
                                </div>
                                
                                <div class="fca-cm-form-group">
                                    <label><?php _e('Created', 'fca-content-manager'); ?></label>
                                    <span id="fca-cm-comment-created" class="fca-cm-meta-value"></span>
                                </div>
                                
                                <div class="fca-cm-form-group">
                                    <label><?php _e('Updated', 'fca-content-manager'); ?></label>
                                    <span id="fca-cm-comment-updated" class="fca-cm-meta-value"></span>
                                </div>
                            </div>
                            
                            <!-- Parent Post -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Parent Post', 'fca-content-manager'); ?></h3>
                                <div id="fca-cm-comment-parent-post" class="fca-cm-relationship-item" style="cursor: pointer;">
                                    <p class="fca-cm-empty-message"><?php _e('Loading...', 'fca-content-manager'); ?></p>
                                </div>
                            </div>
                            
                            <!-- Reactions -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Reactions', 'fca-content-manager'); ?></h3>
                                <div id="fca-cm-comment-reactions-list">
                                    <p class="fca-cm-empty-message"><?php _e('No reactions on this comment', 'fca-content-manager'); ?></p>
                                </div>
                            </div>
                            
                            <!-- Sub Comments (Replies) -->
                            <div class="fca-cm-form-section">
                                <h3><?php _e('Replies', 'fca-content-manager'); ?></h3>
                                <div id="fca-cm-comment-replies-list">
                                    <p class="fca-cm-empty-message"><?php _e('No replies to this comment', 'fca-content-manager'); ?></p>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

