<?php
/**
 * Admin Class
 * Handles admin menu and pages
 */

// Prevent direct access
defined('ABSPATH') or die('No direct script access allowed');

class FCA_CM_Admin {
    
    /**
     * Instance of this class
     */
    private static $instance = null;
    
    /**
     * Get instance
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Constructor
     */
    private function __construct() {
        add_action('admin_menu', array($this, 'add_admin_menu'), 25);
        add_action('admin_enqueue_scripts', array($this, 'enqueue_assets'));
    }
    
    /**
     * Add admin menu
     */
    public function add_admin_menu() {
        add_menu_page(
            __('Content Manager', 'fca-content-manager'),
            __('Content Manager', 'fca-content-manager'),
            'manage_options',
            'fca-content-manager',
            array($this, 'render_overview_page'),
            'dashicons-list-view',
            30
        );
        
        add_submenu_page(
            'fca-content-manager',
            __('Overview', 'fca-content-manager'),
            __('Overview', 'fca-content-manager'),
            'manage_options',
            'fca-content-manager',
            array($this, 'render_overview_page')
        );
        
        add_submenu_page(
            'fca-content-manager',
            __('Posts', 'fca-content-manager'),
            __('Posts', 'fca-content-manager'),
            'manage_options',
            'fca-cm-posts',
            array($this, 'render_posts_page')
        );
        
        add_submenu_page(
            'fca-content-manager',
            __('Courses', 'fca-content-manager'),
            __('Courses', 'fca-content-manager'),
            'manage_options',
            'fca-cm-courses',
            array($this, 'render_courses_page')
        );
        
        add_submenu_page(
            'fca-content-manager',
            __('Members', 'fca-content-manager'),
            __('Members', 'fca-content-manager') . $pro_badge,
            'manage_options',
            'fca-cm-members',
            array($this, 'render_members_page')
        );
        
        add_submenu_page(
            'fca-content-manager',
            __('Comments', 'fca-content-manager'),
            __('Comments', 'fca-content-manager'),
            'manage_options',
            'fca-cm-comments',
            array($this, 'render_comments_page')
        );
        
        add_submenu_page(
            'fca-content-manager',
            __('Reactions', 'fca-content-manager'),
            __('Reactions', 'fca-content-manager'),
            'manage_options',
            'fca-cm-reactions',
            array($this, 'render_reactions_page')
        );
        
        $license_checker = FCA_CM_LicenseChecker::get_instance();
        $pro_badge = $license_checker->is_licensed() ? '' : ' <span class="fca-cm-pro-badge">PRO</span>';
        
        add_submenu_page(
            'fca-content-manager',
            __('Media', 'fca-content-manager'),
            __('Media', 'fca-content-manager') . $pro_badge,
            'manage_options',
            'fca-cm-media',
            array($this, 'render_media_page')
        );
        
        add_submenu_page(
            'fca-content-manager',
            __('Spaces', 'fca-content-manager'),
            __('Spaces', 'fca-content-manager') . $pro_badge,
            'manage_options',
            'fca-cm-spaces',
            array($this, 'render_spaces_page')
        );
        
        add_submenu_page(
            'fca-content-manager',
            __('Metadata', 'fca-content-manager'),
            __('Metadata', 'fca-content-manager') . $pro_badge,
            'manage_options',
            'fca-cm-metadata',
            array($this, 'render_metadata_page')
        );
        
        add_submenu_page(
            'fca-content-manager',
            __('Export', 'fca-content-manager'),
            __('Export', 'fca-content-manager') . $pro_badge,
            'manage_options',
            'fca-cm-export',
            array($this, 'render_export_page')
        );
        
        add_submenu_page(
            'fca-content-manager',
            __('Import', 'fca-content-manager'),
            __('Import', 'fca-content-manager') . $pro_badge,
            'manage_options',
            'fca-cm-import',
            array($this, 'render_import_page')
        );
    }
    
    /**
     * Enqueue admin assets
     */
    public function enqueue_assets($hook) {
        // Only load on our plugin pages
        if (strpos($hook, 'fca-c') === false) {
            return;
        }
        
        // Styles
        wp_enqueue_style(
            'fca-cm-admin',
            FCA_CM_URL . 'assets/css/admin.css',
            array(),
            FCA_CM_VERSION
        );
        
        // Scripts
        wp_enqueue_script(
            'fca-cm-admin',
            FCA_CM_URL . 'assets/js/admin.js',
            array('jquery', 'wp-util'),
            FCA_CM_VERSION,
            true
        );
        
        // Import/Export script (only on import/export pages)
        if (strpos($hook, 'fca-cm-export') !== false || strpos($hook, 'fca-cm-import') !== false) {
            wp_enqueue_script(
                'fca-cm-import-export',
                FCA_CM_URL . 'assets/js/import-export.js',
                array('jquery'),
                FCA_CM_VERSION,
                true
            );
            
            wp_localize_script('fca-cm-import-export', 'fcaContentManager', array(
                'nonce' => wp_create_nonce('fca_cm_nonce'),
                'pluginUrl' => FCA_CM_URL
            ));
        }
        
        // Localize script
        $license_checker = FCA_CM_LicenseChecker::get_instance();
        
        wp_localize_script('fca-cm-admin', 'fcaCMData', array(
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('fca_cm_nonce'),
            'isLicensed' => $license_checker->is_licensed(),
            'upgradeUrl' => $license_checker->get_upgrade_url(),
            'strings' => array(
                'confirmDelete' => __('Are you sure you want to delete this item?', 'fca-content-manager'),
                'confirmBulkDelete' => __('Are you sure you want to delete the selected items?', 'fca-content-manager'),
                'saved' => __('Saved successfully!', 'fca-content-manager'),
                'error' => __('An error occurred. Please try again.', 'fca-content-manager'),
                'loading' => __('Loading...', 'fca-content-manager'),
                'noResults' => __('No results found.', 'fca-content-manager'),
                'upgradeToPro' => __('Upgrade to Pro', 'fca-content-manager'),
                'proFeature' => __('Pro Feature', 'fca-content-manager'),
                'readOnly' => __('Read Only (Pro required for editing)', 'fca-content-manager'),
            )
        ));
    }
    
    /**
     * Render Posts page
     */
    public function render_overview_page() {
        include FCA_CM_PATH . 'views/overview.php';
    }
    
    /**
     * Render posts page
     */
    public function render_posts_page() {
        include FCA_CM_PATH . 'views/posts.php';
    }
    
    /**
     * Render Courses page
     */
    public function render_courses_page() {
        include FCA_CM_PATH . 'views/courses.php';
    }
    
    /**
     * Render Members page
     */
    public function render_members_page() {
        include FCA_CM_PATH . 'views/members.php';
    }
    
    /**
     * Render Comments page
     */
    public function render_comments_page() {
        include FCA_CM_PATH . 'views/comments.php';
    }
    
    /**
     * Render Reactions page
     */
    public function render_reactions_page() {
        include FCA_CM_PATH . 'views/reactions.php';
    }
    
    /**
     * Render Media page
     */
    public function render_media_page() {
        include FCA_CM_PATH . 'views/media.php';
    }
    
    /**
     * Render Spaces page
     */
    public function render_spaces_page() {
        $spaces = FCA_CM_Database::get_spaces();
        include FCA_CM_PATH . 'views/spaces.php';
    }
    
    /**
     * Render Metadata page
     */
    public function render_metadata_page() {
        include FCA_CM_PATH . 'views/metadata.php';
    }
    
    /**
     * Render Export page
     */
    public function render_export_page() {
        include FCA_CM_PATH . 'views/export.php';
    }
    
    /**
     * Render Import page
     */
    public function render_import_page() {
        include FCA_CM_PATH . 'views/import.php';
    }
}

