# FCA Content Manager for Fluent Community

A comprehensive, modern content management system for Fluent Community that provides powerful tools to manage all your community content from one central location.

## Features

### 📝 Posts Management
- **Split-screen interface** with posts list on the left and detailed editor on the right
- **Advanced search and filtering** by status, space, author, and content
- **Bulk operations** - select and delete multiple posts at once
- **Inline editing** - edit title, content, status, privacy settings
- **Real-time metadata** - view comments count, reactions, author, dates
- **Consistent row height** for easy scanning and navigation

### 📚 Courses Management
- **Hierarchical course structure** visualization
- **Skeleton view** of courses with sections and lessons
- **Quick edit and delete** buttons for each section and lesson
- **Course filtering** by space and status
- **Modal editors** for courses and lessons
- **Structured navigation** through course content

### 💬 Comments Management
- **Comprehensive comment listing** across all posts
- **Search functionality** to find specific comments
- **Filter by status** (published, pending, spam)
- **Author and post information** for context
- **Quick delete** for comment moderation

### ❤️ Reactions Management
- **Table view** of all reactions
- **Filter by reaction type** (like, love, laugh, wow, sad, angry)
- **View associated** post and comment IDs
- **User information** for each reaction
- **Quick deletion** for reaction management

### 🖼️ Media Management
- **Visual grid layout** for media files
- **Filter by media type** (images, videos, documents, audio)
- **Active/inactive status** filtering
- **Media preview** with overlay information
- **Storage information** (local, S3, R2)

### ⚙️ Metadata Management
- **Complete metadata overview** for all object types
- **Search by meta key** for quick access
- **Filter by object type** (space, user, post, comment)
- **View and delete** metadata entries
- **Table format** for easy reading

## Installation

1. Upload the `fca-content-manager` folder to your `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Navigate to **Content Manager** in the WordPress admin menu

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- **Fluent Community** plugin must be installed and activated

## User Interface

### Modern Design
- Clean, professional interface inspired by modern web applications
- Responsive layout that works on desktop and tablet devices
- Smooth transitions and hover effects
- Consistent color scheme matching WordPress admin

### Split-Screen Layout
The main Posts and Courses pages feature a split-screen design:
- **Left Panel**: Scrollable list of items with search and filters
- **Right Panel**: Detailed view and editor for selected item
- **Easy Navigation**: Click any item to view/edit instantly

### Efficient Filtering
Every content type includes powerful filtering options:
- Status filters (published, draft, pending, archived)
- Space filters (filter by community space)
- Search functionality
- Items per page selection

## Usage

### Managing Posts

1. **Navigate** to Content Manager → Posts
2. **Search or Filter** posts using the toolbar
3. **Select a post** from the list to view details
4. **Edit** title, content, status, or privacy settings
5. **Save** changes with the "Save Changes" button
6. **Bulk Delete** by selecting multiple posts and clicking "Delete Selected"

### Managing Courses

1. **Navigate** to Content Manager → Courses
2. **Select a course** to view its structure
3. **View sections and lessons** in the hierarchical tree
4. **Edit course** by clicking "Edit Course" button
5. **Edit lessons** by clicking the edit icon next to each lesson
6. **Delete** sections or lessons as needed

### Managing Other Content

All other content types (Comments, Reactions, Media, Metadata) follow similar patterns:
1. Use filters to narrow down results
2. View items in list or table format
3. Click action buttons to edit or delete
4. Use pagination to browse through large datasets

## Developer Information

### File Structure
```
fca-content-manager/
├── fca-content-manager.php    # Main plugin file
├── includes/
│   ├── Admin.php               # Admin menu and pages
│   ├── Ajax.php                # AJAX request handlers
│   ├── Database.php            # Database queries
│   └── Helpers.php             # Helper functions
├── assets/
│   ├── css/
│   │   └── admin.css          # Modern admin styles
│   └── js/
│       └── admin.js           # Interactive functionality
├── views/
│   ├── posts.php              # Posts management page
│   ├── courses.php            # Courses management page
│   ├── comments.php           # Comments management page
│   ├── reactions.php          # Reactions management page
│   ├── media.php              # Media management page
│   └── metadata.php           # Metadata management page
└── README.md                  # This file
```

### Database Tables Used
- `wp_fcom_posts` - Posts, courses, sections, lessons
- `wp_fcom_post_comments` - Comments
- `wp_fcom_post_reactions` - Reactions
- `wp_fcom_media_archive` - Media files
- `wp_fcom_meta` - Metadata
- `wp_fcom_spaces` - Spaces (for filters)

### AJAX Actions
All AJAX actions are prefixed with `fca_cm_` and include:
- `fca_cm_get_posts` - Retrieve posts list
- `fca_cm_get_post` - Get single post details
- `fca_cm_update_post` - Update post data
- `fca_cm_delete_post` - Delete single post
- `fca_cm_bulk_delete_posts` - Delete multiple posts
- Similar actions for comments, reactions, media, metadata

## Security

- All AJAX requests are protected with WordPress nonces
- Capability checks ensure only administrators can access
- Data sanitization on all inputs
- SQL injection prevention through prepared statements
- XSS protection through proper escaping

## Support

For issues, questions, or feature requests, please contact:
- Website: https://fluentcommunityaddons.com
- Documentation: https://fluentcommunityaddons.com/docs/content-manager/

## Changelog

### Version 2.0.0
- **Members Management**: Full user management with enrollment controls
- **Import/Export System**: Import and export content across multiple formats
- **Freemium Model**: License-based feature access with Pro upgrade options
- **Spaces Management**: Manage community spaces with full metadata
- Enhanced bulk operations across all content types
- Improved UI with better scrolling and navigation
- Performance optimizations

### Version 1.0.0
- Initial release
- Posts management with split-screen interface
- Courses management with structure visualization
- Comments, reactions, media, and metadata management
- Modern UI with responsive design
- Advanced search and filtering
- Bulk operations support

## License

This plugin is proprietary software for use with Fluent Community.

## Credits

Developed for the Fluent Community ecosystem.

