# Installation Guide - FCA Content Manager for Fluent Community

## Quick Start

Follow these simple steps to install and activate the Content Manager plugin:

### Step 1: Prerequisites

Before installing, ensure you have:
- ✅ WordPress 5.0 or higher
- ✅ PHP 7.4 or higher  
- ✅ **Fluent Community plugin installed and activated**

### Step 2: Upload Plugin

**Option A: Via WordPress Admin**
1. Go to **Plugins → Add New**
2. Click **Upload Plugin**
3. Choose the `fca-content-manager.zip` file
4. Click **Install Now**

**Option B: Via FTP/File Manager**
1. Upload the `fca-content-manager` folder to `/wp-content/plugins/`
2. Ensure all files are in the correct location

### Step 3: Activate

1. Go to **Plugins → Installed Plugins**
2. Find **FCA Content Manager for Fluent Community**
3. Click **Activate**

### Step 4: Access

Once activated, you'll see a new menu item:
1. Look for **Content Manager** in the WordPress admin sidebar
2. Click it to access the content management interface

## What You'll See

After activation, the Content Manager menu includes:

- **Posts** - Manage all community posts
- **Courses** - Manage courses, sections, and lessons
- **Comments** - Moderate and manage comments
- **Reactions** - View and manage all reactions
- **Media** - Browse and manage media files
- **Metadata** - View and edit metadata

## Folder Structure

Your installation should look like this:

```
wp-content/plugins/fca-content-manager/
├── fca-content-manager.php
├── README.md
├── INSTALLATION.md
├── includes/
│   ├── Admin.php
│   ├── Ajax.php
│   ├── Database.php
│   └── Helpers.php
├── assets/
│   ├── css/
│   │   └── admin.css
│   └── js/
│       └── admin.js
└── views/
    ├── posts.php
    ├── courses.php
    ├── comments.php
    ├── reactions.php
    ├── media.php
    └── metadata.php
```

## Troubleshooting

### Plugin won't activate
- **Check**: Is Fluent Community installed and activated?
- **Solution**: Install and activate Fluent Community first

### Menu doesn't appear
- **Check**: Are you logged in as an administrator?
- **Solution**: Only administrators can access the Content Manager

### Page shows blank or errors
- **Check**: Is your PHP version 7.4 or higher?
- **Solution**: Contact your hosting provider to upgrade PHP

### AJAX errors
- **Check**: Are JavaScript errors in the browser console?
- **Solution**: Clear browser cache and reload the page

### Can't see any posts/content
- **Check**: Do you have posts in your Fluent Community?
- **Solution**: The plugin displays existing content - create some posts in Fluent Community first

## Permissions

The Content Manager requires:
- `manage_options` capability (Administrator role)
- This ensures only trusted users can access content management

## Database

The plugin uses existing Fluent Community database tables:
- No new tables are created
- No database migrations needed
- Works with your existing content

## Uninstallation

To remove the plugin:

1. Go to **Plugins → Installed Plugins**
2. Find **FCA Content Manager for Fluent Community**
3. Click **Deactivate**
4. Click **Delete**

**Note**: Uninstalling this plugin does NOT delete your Fluent Community content. It only removes the management interface.

## Getting Help

If you encounter any issues:

1. **Check the README.md** for feature documentation
2. **Review this guide** for installation steps
3. **Check WordPress debug logs** for error messages
4. **Contact support** at https://fluentcommunityaddons.com

## Next Steps

Once installed:

1. **Explore the Posts page** to see the split-screen interface
2. **Try the search and filters** to find specific content
3. **Edit a post** to see the detailed editor
4. **Check out Courses** to see the structure visualization
5. **Browse other sections** to familiarize yourself with all features

## Updates

To update the plugin:
1. Deactivate the current version
2. Upload and activate the new version
3. Your settings and data are preserved

---

**Enjoy managing your Fluent Community content!** 🎉

