# Changelog

## [1.1.0] - October 5, 2025

### Added - Based on Full Database Analysis

#### New Import/Export Content Types
- **Reactions Import/Export** - Full support for post and comment reactions
  - Object type filtering (feed, comment, etc.)
  - Reaction type filtering (like, love, etc.)
  - Parent reaction support for nested reactions
  - User mapping via email
  - Duplicate prevention

- **Term-Feed Relationships Import/Export** - Post-topic associations
  - Export includes term and post reference data
  - Import validates term and post existence
  - Bulk relationship management
  - Prevents duplicate associations

- **Space Memberships Import/Export** - User-space relationships
  - Role management (admin, student, member)
  - Status tracking (active, inactive)
  - Meta data preservation
  - Bulk membership assignment
  - Filtering by space, user, role, or status

#### Enhanced Existing Features

**Posts Import/Export:**
- Correct `type` field default ('text' instead of 'feed')
- Auto-generate `message_rendered` if missing (wraps in `<p>` tags)
- Proper PHP array serialization for `meta` field (e.g., `a:1:{s:12:"preview_data";N;}`)
- Topic associations via term_feed relationships
- Better validation for required fields

**Spaces Import/Export:**
- Complete metadata support (all fields from database schema)
- Settings serialization for complex configurations
- Parent space relationship handling
- Space type validation (community, course, space_group)

**Comments Import/Export:**
- Auto-generate `message_rendered` if missing
- PHP array serialization for `meta` field
- Nested comment support with parent_id
- Post relationship validation

**Media Import/Export:**
- Settings field serialization (supports both JSON and PHP arrays)
- Driver and source tracking
- Sub-object ID support
- Media key validation

### Improved

#### Data Integrity
- All serialized fields now properly handled (PHP array format)
- Better validation for relationships (user_id, space_id, term_id, post_id)
- Improved error messages with row numbers
- Frontend display issues resolved (message_rendered, type field)

#### User Experience
- Export wizard updated with new content types
- Clear iconography for each content type
- Better organization of export options
- Import supports all new content types
- Enhanced status documentation

#### Technical
- Modular class structure maintained
- Consistent error handling across all import types
- Better code documentation
- Comprehensive testing checklist

### Fixed
- Posts not appearing on frontend due to missing `message_rendered`
- Posts showing as wrong type due to incorrect default `type` value
- Meta fields not serializing correctly (now uses PHP array format)
- Space memberships not exporting/importing
- Reactions not linked to correct objects
- Topic relationships not preserved during import

### Documentation
- Updated `IMPORT-EXPORT-STATUS.md` with full capabilities
- Added detailed implementation notes
- Created comprehensive testing checklist
- Documented database structure insights
- Added known limitations section

## [1.0.0] - October 4, 2025

### Initial Release
- Posts export/import (JSON, CSV)
- Spaces export/import (JSON, CSV)
- Comments export/import (JSON)
- Media metadata export/import (JSON)
- Modern wizard-based UI
- Field mapping for CSV imports
- Duplicate handling options
- Sample templates

## Upcoming

### [1.2.0] - Planned
- Course export/import with full structure
- User profile (XProfile) support
- Chunked import for large datasets
- Background processing for imports
- Media file transfer (not just metadata)

### [2.0.0] - Future
- Direct site-to-site transfer
- Incremental imports (changes only)
- Transform rules and field mapping
- Audit logging
- Import rollback feature
- ZIP package support

