<?php
/**
 * Template for the course search shortcode
 * 
 * Available variables:
 * $atts - Shortcode attributes
 */

// Don't allow direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get FCE Shortcodes instance
global $fce_shortcodes;
global $fce_course_pagination;

// Get course search class
$course_search = new FCE_Course_Search();

// Get course links class
$course_links = new FCE_Course_Links();

// Convert string attributes to boolean
$atts['show_description'] = filter_var($atts['show_description'], FILTER_VALIDATE_BOOLEAN);
$atts['show_image'] = filter_var($atts['show_image'], FILTER_VALIDATE_BOOLEAN);
$atts['show_price'] = filter_var($atts['show_price'], FILTER_VALIDATE_BOOLEAN);
$atts['show_author'] = filter_var($atts['show_author'], FILTER_VALIDATE_BOOLEAN);
$atts['show_categories'] = filter_var($atts['show_categories'], FILTER_VALIDATE_BOOLEAN);

// Get courses
$courses = $course_search->get_courses([
    'per_page' => $atts['per_page'],
    'category' => $atts['category'],
    'author' => $atts['author'],
    'status' => $atts['status']
]);

// Get categories for filter
$categories = $course_search->get_categories();

// Default course image
$default_course_image = plugin_dir_url(dirname(__FILE__)) . 'assets/images/default-course.svg';
?>

<div class="fce-course-search" data-per-page="<?php echo esc_attr($atts['per_page']); ?>" 
     data-show-description="<?php echo $atts['show_description'] ? 'true' : 'false'; ?>"
     data-show-image="<?php echo $atts['show_image'] ? 'true' : 'false'; ?>"
     data-show-price="<?php echo $atts['show_price'] ? 'true' : 'false'; ?>"
     data-show-author="<?php echo $atts['show_author'] ? 'true' : 'false'; ?>"
     data-show-categories="<?php echo $atts['show_categories'] ? 'true' : 'false'; ?>"
     data-initial-category="<?php echo esc_attr($atts['category']); ?>"
     data-initial-author="<?php echo esc_attr($atts['author']); ?>"
     data-initial-status="<?php echo esc_attr($atts['status']); ?>">
    
    <div class="fce-course-search-header">
        <h2><?php _e('Course Catalog', 'fce-shortcodes'); ?></h2>
        
        <div class="fce-course-search-filters">
            <div class="fce-course-search-filter">
                <input type="text" class="fce-course-search-input" placeholder="<?php _e('Search courses...', 'fce-shortcodes'); ?>">
            </div>
            
            <?php if (!empty($categories)): ?>
            <div class="fce-course-search-filter">
                <select class="fce-course-category-filter">
                    <option value=""><?php _e('All Categories', 'fce-shortcodes'); ?></option>
                    <?php foreach ($categories as $category): ?>
                        <option value="<?php echo esc_attr($category->slug); ?>" <?php selected($atts['category'], $category->slug); ?>>
                            <?php echo esc_html($category->title); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <?php endif; ?>
            
            <?php if (!empty($authors) && $atts['show_author']): ?>
            <div class="fce-course-search-filter">
                <select class="fce-course-author-filter">
                    <option value=""><?php _e('All Instructors', 'fce-shortcodes'); ?></option>
                    <?php foreach ($authors as $author): ?>
                        <option value="<?php echo esc_attr($author->ID); ?>" <?php selected($atts['author'], $author->ID); ?>>
                            <?php echo esc_html($author->display_name); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <?php endif; ?>
            
            <div class="fce-course-search-filter">
                <select class="fce-course-sort-filter">
                    <option value="title-asc"><?php _e('Title (A-Z)', 'fce-shortcodes'); ?></option>
                    <option value="title-desc"><?php _e('Title (Z-A)', 'fce-shortcodes'); ?></option>
                    <option value="created_at-desc"><?php _e('Newest First', 'fce-shortcodes'); ?></option>
                    <option value="created_at-asc"><?php _e('Oldest First', 'fce-shortcodes'); ?></option>
                </select>
            </div>
        </div>
    </div>
    
    <div class="fce-course-search-results">
        <?php if (empty($courses)): ?>
            <div class="fce-course-search-no-results">
                <p><?php _e('No courses found.', 'fce-shortcodes'); ?></p>
            </div>
        <?php else: ?>
            <div class="fce-course-grid">
                <?php foreach ($courses as $course): 
                    // Get course meta
                    $price = $course_search->get_course_price($course->id);
                    $is_free = $course_search->is_course_free($course->id);
                    $author = $course_search->get_course_author($course->id);
                    $categories = $course_search->get_course_categories($course->id);
                    
                    // Replace the image display code with this updated version
                    $image_html = '';
                    if ($atts['show_image']) {
                        // First check if the course has a cover_photo directly in the spaces table
                        $cover_photo = !empty($course->cover_photo) ? esc_url($course->cover_photo) : '';
                        
                        // If no direct cover_photo, try to get the image from the course_search method
                        if (empty($cover_photo)) {
                            $cover_photo = $course->image_url;
                        }
                        
                        // Use the cover photo if we have one, otherwise use placeholder
                        if (!empty($cover_photo) && $cover_photo !== plugin_dir_url(dirname(__FILE__)) . 'assets/images/default-course.png') {
                            $image_html = '<div class="fce-course-image"><img src="' . $cover_photo . '" alt="' . esc_attr($course->title) . '" /></div>';
                        } else {
                            // Use placeholder image when no cover photo is available
                            $placeholder_url = plugin_dir_url(dirname(__FILE__)) . 'assets/images/course-placeholder.jpg';
                            $image_html = '<div class="fce-course-image"><img src="' . $placeholder_url . '" alt="' . esc_attr($course->title) . '" /></div>';
                        }
                    }
                    
                    // Build course URL
                    $course_url = $course_links->get_course_permalink($course->id);
                ?>
                    <div class="fce-course-card">
                        <?php echo $image_html; ?>
                        
                        <div class="fce-course-content">
                            <h3 class="fce-course-title">
                                <a href="<?php echo esc_url($course_url); ?>"><?php echo esc_html($course->title); ?></a>
                            </h3>
                            
                            <?php if ($atts['show_author'] && $author): ?>
                                <div class="fce-course-author">
                                    <span>By <?php echo esc_html($author->display_name); ?></span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($atts['show_description'] && !empty($course->description)): ?>
                                <div class="fce-course-description">
                                    <?php echo wp_kses_post(wp_trim_words($course->description, 20)); ?>
                                </div>
                            <?php endif; ?>
                            
                            <div class="fce-course-meta">
                                <div class="fce-course-lessons">
                                    <?php echo sprintf(_n('%d Lesson', '%d Lessons', $course->lesson_count, 'fce-shortcodes'), $course->lesson_count); ?>
                                </div>
                                
                                <?php if ($atts['show_price']): ?>
                                    <div class="fce-course-price">
                                        <?php if ($is_free): ?>
                                            <span class="fce-price-free">Free</span>
                                        <?php else: ?>
                                            <span class="fce-price"><?php echo esc_html($price); ?></span>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <?php if ($atts['show_categories'] && !empty($categories)): ?>
                                <div class="fce-course-categories">
                                    <?php 
                                    $category_links = [];
                                    foreach ($categories as $category) {
                                        $category_links[] = '<a href="#" data-category="' . esc_attr($category->slug) . '">' . esc_html($category->title) . '</a>';
                                    }
                                    echo implode(', ', $category_links);
                                    ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <?php if (count($courses) >= $atts['per_page']): ?>
                <div class="fce-course-pagination">
                    <button class="fce-course-pagination-prev" <?php echo ($fce_course_pagination['current_page'] <= 1) ? 'disabled' : ''; ?>><?php _e('Previous', 'fce-shortcodes'); ?></button>
                    <span class="fce-course-pagination-info"><?php echo sprintf(__('Page %1$d of %2$d', 'fce-shortcodes'), $fce_course_pagination['current_page'], $fce_course_pagination['pages']); ?></span>
                    <button class="fce-course-pagination-next" <?php echo ($fce_course_pagination['current_page'] >= $fce_course_pagination['pages']) ? 'disabled' : ''; ?>><?php _e('Next', 'fce-shortcodes'); ?></button>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div> 