<?php
/**
 * Template for the community stats shortcode
 * 
 * Available variables:
 * $atts - Shortcode attributes
 */

// Don't allow direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get stats class
$stats = new FCE_Community_Stats();

// Get the requested statistic
$stat_data = $stats->get_stats([
    'stat_type' => $atts['stat_type'],
    'space_id' => $atts['space_id'],
    'course_id' => $atts['course_id'],
    'time_period' => $atts['time_period'],
]);

// Get icon class
$icon_class = !empty($stat_data['icon']) ? $stat_data['icon'] : 'dashicons-info';

// Get custom colors
$background_color = !empty($atts['background_color']) ? $atts['background_color'] : '#ffffff';
$text_color = !empty($atts['text_color']) ? $atts['text_color'] : '#333333';
$accent_color = !empty($atts['accent_color']) ? $atts['accent_color'] : '';

// Generate a unique ID for this instance
$unique_id = 'fce-stat-' . uniqid();

// Custom inline styles
$custom_styles = "
    #{$unique_id} {
        background-color: {$background_color};
        color: {$text_color};
    }
";

// Add accent color if specified
if (!empty($accent_color)) {
    $custom_styles .= "
        #{$unique_id}:after {
            background-color: {$accent_color};
        }
        #{$unique_id} .fce-stat-icon .dashicons {
            color: {$accent_color};
        }
        #{$unique_id} .fce-stat-value {
            color: {$accent_color};
        }
        #{$unique_id} .fce-stat-icon:before {
            background-color: {$accent_color}10;
        }
    ";
}
?>

<style>
    <?php echo $custom_styles; ?>
</style>

<div id="<?php echo esc_attr($unique_id); ?>" class="fce-community-stat <?php echo esc_attr($atts['layout']); ?> <?php echo esc_attr($atts['size']); ?>" data-stat-type="<?php echo esc_attr($atts['stat_type']); ?>" data-end-value="<?php echo esc_attr($stat_data['value']); ?>">
    <div class="fce-stat-icon">
        <?php echo $stat_data['icon']; ?>
    </div>
    
    <div class="fce-stat-content">
        <div class="fce-stat-value"><?php echo esc_html($stat_data['value']); ?></div>
        <div class="fce-stat-label"><?php echo esc_html($stat_data['label']); ?></div>
    </div>
    
    <?php if (!empty($atts['show_description']) && !empty($atts['description'])): ?>
        <div class="fce-stat-description">
            <?php echo wp_kses_post($atts['description']); ?>
        </div>
    <?php endif; ?>
</div> 