<?php
/**
 * Template for the community stats grid shortcode
 * 
 * Available variables:
 * $atts - Shortcode attributes
 */

// Don't allow direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get stats class
$stats = new FCE_Community_Stats();

// Parse the stats to display
$stats_to_display = explode(',', $atts['stats']);
$stats_to_display = array_map('trim', $stats_to_display);

// Generate a unique ID for this instance
$unique_id = 'fce-stats-grid-' . uniqid();
?>

<div id="<?php echo esc_attr($unique_id); ?>" class="fce-stats-grid columns-<?php echo esc_attr($atts['columns']); ?>">
    <?php foreach ($stats_to_display as $stat_type): ?>
        <?php
        // Get the requested statistic
        $stat_data = $stats->get_stats([
            'stat_type' => $stat_type,
            'space_id' => $atts['space_id'],
            'course_id' => $atts['course_id'],
            'time_period' => $atts['time_period'],
        ]);
        
        // Generate a unique ID for this stat
        $stat_unique_id = 'fce-stat-' . uniqid();
        ?>
        
        <div id="<?php echo esc_attr($stat_unique_id); ?>" class="fce-community-stat <?php echo esc_attr($atts['layout']); ?> <?php echo esc_attr($atts['size']); ?>" data-stat-type="<?php echo esc_attr($stat_type); ?>" data-end-value="<?php echo esc_attr($stat_data['value']); ?>">
            <div class="fce-stat-icon">
                <?php echo $stat_data['icon']; ?>
            </div>
            
            <div class="fce-stat-content">
                <div class="fce-stat-value"><?php echo esc_html($stat_data['value']); ?></div>
                <div class="fce-stat-label"><?php echo esc_html($stat_data['label']); ?></div>
            </div>
        </div>
    <?php endforeach; ?>
</div> 