<?php
/**
 * Template for displaying a single community stat
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Generate unique ID for this stat
$stat_id = 'fce-stat-' . uniqid();

// Prepare CSS variables
$css_vars = [];
if (!empty($atts['background_color'])) {
    $css_vars[] = '--fce-stat-bg-color: ' . $atts['background_color'];
}
if (!empty($atts['text_color'])) {
    $css_vars[] = '--fce-stat-text-color: ' . $atts['text_color'];
}
if (!empty($atts['accent_color'])) {
    $css_vars[] = '--fce-stat-accent-color: ' . $atts['accent_color'];
}

// Prepare CSS classes
$classes = [
    'fce-community-stat',
    'fce-layout-' . $atts['layout'],
    'fce-size-' . $atts['size'],
    'fce-template-' . $atts['template']
];

// Check if we're using the fluent template
$is_fluent = ($atts['template'] === 'fluent');

// Prepare inline style
$style = !empty($css_vars) ? ' style="' . implode('; ', $css_vars) . ';"' : '';
?>

<div id="<?php echo esc_attr($stat_id); ?>" class="<?php echo esc_attr(implode(' ', $classes)); ?>"<?php echo $style; ?>>
    <?php if ($is_fluent): ?>
    <!-- Fluent Community Style -->
    <div class="fce-stat-card">
        <div class="fce-stat-icon">
            <?php echo $stat['icon']; ?>
        </div>
        <div class="fce-stat-content">
            <div class="fce-stat-value"><?php echo esc_html($stat['value']); ?></div>
            <div class="fce-stat-label"><?php echo esc_html($stat['label']); ?></div>
        </div>
    </div>
    <?php else: ?>
    <!-- Default Style -->
    <div class="fce-stat-icon">
        <?php echo $stat['icon']; ?>
    </div>
    <div class="fce-stat-content">
        <div class="fce-stat-value"><?php echo esc_html($stat['value']); ?></div>
        <div class="fce-stat-label"><?php echo esc_html($stat['label']); ?></div>
        <?php if ($atts['show_description']): ?>
        <div class="fce-stat-description">
            <?php 
            $description = '';
            switch ($atts['stat_type']) {
                case 'total_members':
                    $description = __('Total registered members in the community', 'fce-shortcodes');
                    break;
                case 'total_enrolled':
                    if ($atts['course_id'] > 0) {
                        $description = __('Total users enrolled in this course', 'fce-shortcodes');
                    } else {
                        $description = __('Total enrollments across all courses', 'fce-shortcodes');
                    }
                    break;
                case 'total_posts':
                    $description = __('Total posts in the community', 'fce-shortcodes');
                    break;
                case 'total_comments':
                    $description = __('Total comments in the community', 'fce-shortcodes');
                    break;
                case 'total_courses':
                    $description = __('Total courses available', 'fce-shortcodes');
                    break;
                case 'recent_posts':
                    switch ($atts['time_period']) {
                        case 'today':
                            $description = __('Posts created today', 'fce-shortcodes');
                            break;
                        case 'week':
                            $description = __('Posts created in the last week', 'fce-shortcodes');
                            break;
                        case 'month':
                            $description = __('Posts created in the last month', 'fce-shortcodes');
                            break;
                        default:
                            $description = __('Total posts in the community', 'fce-shortcodes');
                    }
                    break;
                case 'recent_comments':
                    switch ($atts['time_period']) {
                        case 'today':
                            $description = __('Comments created today', 'fce-shortcodes');
                            break;
                        case 'week':
                            $description = __('Comments created in the last week', 'fce-shortcodes');
                            break;
                        case 'month':
                            $description = __('Comments created in the last month', 'fce-shortcodes');
                            break;
                        default:
                            $description = __('Total comments in the community', 'fce-shortcodes');
                    }
                    break;
                case 'active_users':
                    switch ($atts['time_period']) {
                        case 'today':
                            $description = __('Users active today', 'fce-shortcodes');
                            break;
                        case 'week':
                            $description = __('Users active in the last week', 'fce-shortcodes');
                            break;
                        case 'month':
                            $description = __('Users active in the last month', 'fce-shortcodes');
                            break;
                        default:
                            $description = __('Total active users', 'fce-shortcodes');
                    }
                    break;
                case 'course_completion_rate':
                    $description = __('Percentage of enrolled users who completed the course', 'fce-shortcodes');
                    break;
            }
            echo esc_html($description);
            ?>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</div> 