<?php

/**
 * FCE_Course_Search class
 *
 * @package FCE_Shortcodes
 * @since 1.0.0
 */
class FCE_Course_Search {

    /**
     * Get default course image URL
     *
     * @return string
     */
    public function get_default_course_image() {
        $default_image = plugin_dir_url( dirname( __FILE__ ) ) . 'assets/images/default-course.png';
        return apply_filters( 'fce_shortcodes_default_course_image', $default_image );
    }

    /**
     * Get course image
     *
     * @param int $course_id
     * @return string
     */
    public function get_course_image( $course_id ) {
        $image_id = get_post_meta( $course_id, '_thumbnail_id', true );
        
        if ( $image_id ) {
            $image = wp_get_attachment_image_src( $image_id, 'medium' );
            if ( $image ) {
                return $image[0];
            }
        }
        
        // Return default image if no course image is found
        return $this->get_default_course_image();
    }
} 