<?php

/**
 * FCE_Course_Links class
 *
 * @package FCE_Shortcodes
 * @since 1.0.0
 */
class FCE_Course_Links {
    
    /**
     * Get the portal slug
     *
     * @return string
     */
    private function get_portal_slug() {
        // Get the portal slug from settings
        $settings = get_option('fce_shortcodes_settings', []);
        $portal_slug = isset($settings['portal_slug']) ? $settings['portal_slug'] : 'social';
        
        // Allow filtering of the portal slug
        return apply_filters('fce_shortcodes_portal_slug', $portal_slug);
    }
    
    /**
     * Get course permalink
     *
     * @param int $course_id
     * @return string
     */
    public function get_course_permalink($course_id) {
        // Get the portal URL from settings
        $settings = get_option('fce_shortcodes_settings', []);
        $portal_url = isset($settings['portal_url']) ? $settings['portal_url'] : '';
        
        // If no portal URL is set, use the site URL
        if (empty($portal_url)) {
            $portal_url = site_url();
        }
        
        // Ensure portal URL ends with a slash
        $portal_url = trailingslashit($portal_url);
        
        // Get course slug
        global $wpdb;
        $course_slug = $wpdb->get_var($wpdb->prepare(
            "SELECT slug FROM {$wpdb->prefix}fcom_spaces
            WHERE id = %d",
            $course_id
        ));
        
        if (!$course_slug) {
            return '';
        }
        
        // Get the portal slug
        $portal_slug = $this->get_portal_slug();
        
        // Build the course URL with the correct structure for FluentCommunity
        $course_url = $portal_url . $portal_slug . '/course/' . $course_slug . '/lessons';
        
        return apply_filters('fce_shortcodes_course_permalink', $course_url, $course_id);
    }
    
    /**
     * Get lesson permalink
     *
     * @param int $lesson_id
     * @return string
     */
    public function get_lesson_permalink($lesson_id) {
        global $wpdb;
        
        // Get lesson data
        $lesson = $wpdb->get_row($wpdb->prepare(
            "SELECT p.*, s.slug as course_slug
            FROM {$wpdb->prefix}fcom_posts p
            JOIN {$wpdb->prefix}fcom_spaces s ON p.space_id = s.id
            WHERE p.id = %d AND p.type = 'course_lesson'",
            $lesson_id
        ));
        
        if (!$lesson) {
            return '';
        }
        
        // Get the portal URL from settings
        $settings = get_option('fce_shortcodes_settings', []);
        $portal_url = isset($settings['portal_url']) ? $settings['portal_url'] : '';
        
        // If no portal URL is set, use the site URL
        if (empty($portal_url)) {
            $portal_url = site_url();
        }
        
        // Ensure portal URL ends with a slash
        $portal_url = trailingslashit($portal_url);
        
        // Get the portal slug
        $portal_slug = $this->get_portal_slug();
        
        // Build the lesson URL with the correct structure for FluentCommunity
        $lesson_url = $portal_url . $portal_slug . '/course/' . $lesson->course_slug . '/lesson/' . $lesson->slug;
        
        return apply_filters('fce_shortcodes_lesson_permalink', $lesson_url, $lesson_id);
    }
} 