/**
 * FCE Shortcodes Admin Scripts
 */
(function($) {
    'use strict';
    
    // Initialize when DOM is ready
    $(document).ready(function() {
        // Tab functionality
        $('.fce-tab-button').on('click', function() {
            var tabId = $(this).data('tab');
            
            // Update active tab button
            $('.fce-tab-button').removeClass('active');
            $(this).addClass('active');
            
            // Show the selected tab content
            $('.fce-tab-content').removeClass('active');
            $('#' + tabId + '-tab').addClass('active');
        });
        
        // Copy shortcode functionality
        $('.fce-copy-shortcode').on('click', function() {
            var shortcode = $(this).data('shortcode');
            copyToClipboard(shortcode);
            
            // Show copied message
            var $button = $(this);
            var originalText = $button.text();
            $button.text('Copied!');
            
            setTimeout(function() {
                $button.text(originalText);
            }, 2000);
        });
        
        // Clear color input
        $('.cs-clear-color').on('click', function() {
            var targetId = $(this).data('target');
            $('#' + targetId).val('');
            updateCommunityStatShortcode();
        });
        
        // Course Search Shortcode Builder
        function updateCourseSearchShortcode() {
            var perPage = $('#cs-per-page').val();
            var showDescription = $('#cs-show-description').val();
            var showImage = $('#cs-show-image').val();
            var showPrice = $('#cs-show-price').val();
            var showAuthor = $('#cs-show-author').val();
            var showCategories = $('#cs-show-categories').val();
            var category = $('#cs-category').val();
            var author = $('#cs-author').val();
            var status = $('#cs-status').val();
            
            var shortcode = '[fce_course_search';
            
            // Add attributes if they differ from defaults
            if (perPage) {
                shortcode += ' per_page="' + perPage + '"';
            }
            
            if (showDescription !== 'true') {
                shortcode += ' show_description="' + showDescription + '"';
            }
            
            if (showImage !== 'true') {
                shortcode += ' show_image="' + showImage + '"';
            }
            
            if (showPrice !== 'true') {
                shortcode += ' show_price="' + showPrice + '"';
            }
            
            if (showAuthor !== 'true') {
                shortcode += ' show_author="' + showAuthor + '"';
            }
            
            if (showCategories !== 'true') {
                shortcode += ' show_categories="' + showCategories + '"';
            }
            
            if (category) {
                shortcode += ' category="' + category + '"';
            }
            
            if (author) {
                shortcode += ' author="' + author + '"';
            }
            
            if (status !== 'published') {
                shortcode += ' status="' + status + '"';
            }
            
            shortcode += ']';
            
            // Update preview
            $('#cs-shortcode-preview').text(shortcode);
            $('.fce-copy-shortcode').data('shortcode', shortcode);
        }
        
        // Community Stat Shortcode Builder
        function updateCommunityStatShortcode() {
            var statType = $('#fce-stat-type').val();
            var spaceId = $('#fce-space-id').val();
            var courseId = $('#fce-course-id').val();
            var timePeriod = $('#fce-time-period').val();
            var layout = $('#fce-stat-layout').val();
            var size = $('#fce-stat-size').val();
            var bgColor = $('#fce-stat-bg-color').val();
            var textColor = $('#fce-stat-text-color').val();
            var accentColor = $('#fce-stat-accent-color').val();
            var showDescription = $('#fce-stat-show-description').is(':checked') ? 'yes' : 'no';
            
            var shortcode = '[fce_community_stat';
            
            // Always include stat_type
            shortcode += ' stat_type="' + statType + '"';
            
            // Only include non-empty attributes
            if (spaceId) shortcode += ' space_id="' + spaceId + '"';
            if (courseId) shortcode += ' course_id="' + courseId + '"';
            
            // Only include non-default time_period
            if (timePeriod && timePeriod !== 'all') {
                shortcode += ' time_period="' + timePeriod + '"';
            }
            
            // Only include non-default layout
            if (layout && layout !== 'standard') {
                shortcode += ' layout="' + layout + '"';
            }
            
            // Only include non-default size
            if (size && size !== 'medium') {
                shortcode += ' size="' + size + '"';
            }
            
            // Only include colors if they're set
            if (bgColor) shortcode += ' background_color="' + bgColor + '"';
            if (textColor) shortcode += ' text_color="' + textColor + '"';
            if (accentColor) shortcode += ' accent_color="' + accentColor + '"';
            
            // Only include show_description if it's not the default
            if (showDescription !== 'yes') {
                shortcode += ' show_description="' + showDescription + '"';
            }
            
            shortcode += ']';
            
            $('#fce-community-stat-preview').text(shortcode);
            
            // Show/hide course_id field based on stat_type
            if (statType === 'total_enrolled' || statType === 'course_completion_rate' || statType === 'total_completed') {
                $('.fce-course-id-field').show();
            } else {
                $('.fce-course-id-field').hide();
            }
            
            // Show/hide space_id field based on stat_type
            if (statType === 'total_posts' || statType === 'total_comments' || statType === 'recent_posts' || statType === 'recent_comments') {
                $('.fce-space-id-field').show();
            } else {
                $('.fce-space-id-field').hide();
            }
            
            // Show/hide time_period field based on stat_type
            if (statType === 'recent_posts' || statType === 'recent_comments' || statType === 'active_users' || statType === 'total_completed') {
                $('.fce-time-period-field').show();
            } else {
                $('.fce-time-period-field').hide();
            }
        }
        
        // Community Stats Grid Shortcode Builder
        function updateCommunityStatsGridShortcode() {
            var stats = [];
            $('input[name="stats[]"]:checked').each(function() {
                stats.push($(this).val());
            });
            
            var spaceId = $('#csg-space-id').val();
            var courseId = $('#csg-course-id').val();
            var timePeriod = $('#csg-time-period').val();
            var layout = $('#csg-layout').val();
            var size = $('#csg-size').val();
            var columns = $('#csg-columns').val();
            
            var shortcode = '[fce_community_stats';
            
            // Add stats attribute
            if (stats.length > 0) {
                shortcode += ' stats="' + stats.join(',') + '"';
            } else {
                // Default stats if none selected
                shortcode += ' stats="total_members,total_enrolled,total_posts,total_comments"';
            }
            
            // Add optional attributes if they have values
            if (spaceId && spaceId !== '0') {
                shortcode += ' space_id="' + spaceId + '"';
            }
            
            if (courseId && courseId !== '0') {
                shortcode += ' course_id="' + courseId + '"';
            }
            
            if (timePeriod !== 'all') {
                shortcode += ' time_period="' + timePeriod + '"';
            }
            
            if (layout !== 'horizontal') {
                shortcode += ' layout="' + layout + '"';
            }
            
            if (size !== 'medium') {
                shortcode += ' size="' + size + '"';
            }
            
            if (columns !== '4') {
                shortcode += ' columns="' + columns + '"';
            }
            
            shortcode += ']';
            
            // Update preview
            $('#grid-shortcode-preview').text(shortcode);
            $('.fce-tab-content.active .fce-copy-shortcode').data('shortcode', shortcode);
        }
        
        // Toggle description field visibility
        $('#cs-show-desc').on('change', function() {
            if ($(this).val() === 'true') {
                $('.cs-description-field').show();
            } else {
                $('.cs-description-field').hide();
            }
        });
        
        // Attach event listeners for course search builder
        $('#cs-per-page, #cs-show-description, #cs-show-image, #cs-show-price, #cs-show-author, #cs-show-categories, #cs-category, #cs-author, #cs-status').on('change input', updateCourseSearchShortcode);
        
        // Attach event listeners for community stat builder
        $('#fce-stat-type, #fce-space-id, #fce-course-id, #fce-time-period, #fce-stat-layout, #fce-stat-size, #fce-stat-bg-color, #fce-stat-text-color, #fce-stat-accent-color, #fce-stat-show-description').on('change input', updateCommunityStatShortcode);
        
        // Attach event listeners for community stats grid builder
        $('input[name="stats[]"], #csg-space-id, #csg-course-id, #csg-time-period, #csg-layout, #csg-size, #csg-columns').on('change input', updateCommunityStatsGridShortcode);
        
        // Initialize shortcode previews
        updateCourseSearchShortcode();
        updateCommunityStatShortcode();
        updateCommunityStatsGridShortcode();
        
        // Helper function to copy text to clipboard
        function copyToClipboard(text) {
            var $temp = $('<textarea>');
            $('body').append($temp);
            $temp.val(text).select();
            document.execCommand('copy');
            $temp.remove();
        }
    });
    
})(jQuery); 