<?php
/**
 * Create a default course image
 * 
 * This script generates a simple placeholder image for courses and saves it to the file system.
 * Run this script once to create the default-course.png file.
 */

// Path to save the image
$image_path = __DIR__ . '/default-course.png';

// Create a 600x400 image
$image = imagecreatetruecolor(600, 400);

// Define colors
$bg_color = imagecolorallocate($image, 233, 236, 239); // #e9ecef
$text_color = imagecolorallocate($image, 73, 80, 87);  // #495057
$border_color = imagecolorallocate($image, 206, 212, 218); // #ced4da

// Fill the background
imagefill($image, 0, 0, $bg_color);

// Add a border
imagerectangle($image, 0, 0, 599, 399, $border_color);

// Add text
$font = 5; // Built-in font
$text = "Course Image";
$text_width = imagefontwidth($font) * strlen($text);
$text_height = imagefontheight($font);
$x = (600 - $text_width) / 2;
$y = (400 - $text_height) / 2;

imagestring($image, $font, $x, $y, $text, $text_color);

// Save the image to file
if (imagepng($image, $image_path)) {
    echo "Default course image created successfully at: $image_path\n";
} else {
    echo "Failed to create default course image\n";
}

// Free memory
imagedestroy($image); 