# FCE Shortcodes

FCE Shortcodes is a WordPress plugin that provides shortcodes to display Fluent Community content anywhere on your WordPress site.

## Description

This plugin extends the functionality of the Fluent Community platform by allowing you to embed community content in any WordPress page or post using shortcodes. It's perfect for creating landing pages, course catalogs, or integrating community content with your main website.

## Features

- **Course Search Shortcode**: Display a beautiful, filterable course catalog with search functionality
- **Responsive Design**: Looks great on all devices
- **Customizable**: Many options to control the display of courses
- **AJAX-Powered**: Fast, dynamic loading without page refreshes
- **Demo Content Importer**: Easily import sample courses and lessons for testing

## Installation

1. Upload the `fce-shortcodes` folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Configure the plugin settings under the 'FCE Shortcodes' menu
4. Optionally, import demo content from the 'Import Demo Content' submenu

## Usage

### Course Search Shortcode

Use the `[fce_course_search]` shortcode to display a course search feature on any page or post.

**Basic Usage:**
```
[fce_course_search]
```

**Advanced Usage:**
```
[fce_course_search per_page="12" show_description="true" show_image="true" show_price="true" show_author="true" show_categories="true" category="programming" status="published"]
```

**Available Attributes:**

- `per_page`: Number of courses per page (default: 10)
- `show_description`: Show course description (default: true)
- `show_image`: Show course image (default: true)
- `show_price`: Show course price (default: true)
- `show_author`: Show course author (default: true)
- `show_categories`: Show course categories (default: true)
- `category`: Filter by category slug (default: empty)
- `author`: Filter by author ID (default: empty)
- `status`: Filter by status (default: published)

## Demo Content

The plugin includes a demo content importer that allows you to quickly create sample courses and lessons for testing purposes. To import demo content:

1. Go to the 'FCE Shortcodes' menu in your WordPress admin
2. Click on the 'Import Demo Content' submenu
3. Choose how many courses and lessons you want to create
4. Click 'Import Demo Content'

The importer will create:
- Sample courses with realistic titles and descriptions
- Lessons for each course with formatted content
- Categories for organizing the courses

This is perfect for testing the shortcodes and seeing how they'll look with real content.

## Requirements

- WordPress 5.0 or higher
- Fluent Community plugin installed and activated
- PHP 7.0 or higher

## Changelog

### 1.0.0
- Initial release
- Added course search shortcode
- Added demo content importer

## Credits

Developed by Acamedia based on the Fluent Community Everywhere plugin. 